/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LogsSelector {
    protected final List<ILoggingEvent> list;

    public LogsSelector(List<ILoggingEvent> list) {
        this.list = list;
    }

    public boolean empty() {
        return this.count() == 0;
    }

    public int count() {
        return this.list.size();
    }

    public List<ILoggingEvent> events() {
        return this.list;
    }

    public List<String> messages() {
        return this.messages(ILoggingEvent::getFormattedMessage);
    }

    public List<String> messages(Function<ILoggingEvent, String> mapper) {
        return this.list.stream().map(mapper).collect(Collectors.toList());
    }

    public ILoggingEvent lastEvent() {
        return this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
    }

    public String lastMessage() {
        ILoggingEvent lastEvent = this.lastEvent();
        return lastEvent == null ? null : lastEvent.getFormattedMessage();
    }

    public boolean has(String loggerName) {
        return this.list.stream().anyMatch(event -> event.getLoggerName().equals(loggerName));
    }

    public boolean has(Class<?> logger) {
        return this.has(logger.getName());
    }

    public boolean has(org.slf4j.event.Level level) {
        Level reqLevel = Level.valueOf((String)level.toString());
        return this.list.stream().anyMatch(event -> event.getLevel().equals(reqLevel));
    }

    public LogsSelector select(Predicate<ILoggingEvent> predicate) {
        return new LogsSelector(this.list.stream().filter(predicate).collect(Collectors.toList()));
    }

    public LogsSelector level(org.slf4j.event.Level ... levels) {
        List reqLevel = Arrays.stream(levels).map(it -> Level.valueOf((String)it.toString())).collect(Collectors.toList());
        return this.select(event -> reqLevel.contains(event.getLevel()));
    }

    public LogsSelector logger(String ... loggerNames) {
        List loggers = Arrays.stream(loggerNames).collect(Collectors.toList());
        return this.select(event -> loggers.contains(event.getLoggerName()));
    }

    public LogsSelector logger(Class<?> ... logger) {
        return this.logger((String[])Arrays.stream(logger).map(Class::getName).toArray(String[]::new));
    }

    public LogsSelector containing(String messagePart) {
        return this.select(event -> event.getFormattedMessage().contains(messagePart));
    }

    public LogsSelector matching(String regex) {
        Pattern pattern = Pattern.compile(regex);
        return this.select(event -> pattern.matcher(event.getFormattedMessage()).find());
    }
}

