/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.track.stat;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.test.track.MethodTrack;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public class MethodSummary
implements Comparable<MethodSummary> {
    private final Class<?> service;
    private final Method method;
    private final Set<String> instances = new HashSet<String>();
    private int tracks;
    private int errors;
    private final Snapshot snapshot;

    public MethodSummary(Class<?> service, Method method, Timer timer) {
        this.service = service;
        this.method = method;
        this.snapshot = timer.getSnapshot();
    }

    public void add(MethodTrack track) {
        ++this.tracks;
        if (!track.isSuccess()) {
            ++this.errors;
        }
        this.instances.add(track.getInstanceHash());
    }

    public Class<?> getService() {
        return this.service;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getTracks() {
        return this.tracks;
    }

    public int getErrors() {
        return this.errors;
    }

    public Snapshot getMetrics() {
        return this.snapshot;
    }

    public String getMin() {
        return PrintUtils.formatMetric(this.snapshot.getMin());
    }

    public String getMax() {
        return PrintUtils.formatMetric(this.snapshot.getMax());
    }

    public String getMedian() {
        return PrintUtils.formatMetric(this.snapshot.getMedian());
    }

    public String get75thPercentile() {
        return PrintUtils.formatMetric(this.snapshot.get75thPercentile());
    }

    public String get95thPercentile() {
        return PrintUtils.formatMetric(this.snapshot.get95thPercentile());
    }

    public int getInstancesCount() {
        return this.instances.size();
    }

    public String toStringMethod() {
        return this.method.getName() + "(" + Arrays.stream(this.method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }

    public String toString() {
        return this.toStringMethod() + " called " + this.tracks + " times" + (String)(this.errors > 0 ? " (" + this.errors + ")" : "") + (String)(this.instances.size() > 1 ? " (on " + this.instances.size() + " instances)" : "");
    }

    @Override
    public int compareTo(MethodSummary o) {
        return Double.compare(this.snapshot.getMedian(), o.snapshot.getMedian());
    }
}

