/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.orient;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.jetty.NonblockingServletHolder;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.lang.reflect.Field;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.orient.configuration.HasOrientServerConfiguration;
import ru.vyarus.dropwizard.orient.configuration.OrientServerConfiguration;
import ru.vyarus.dropwizard.orient.health.OrientServerHealthCheck;
import ru.vyarus.dropwizard.orient.internal.DummyTraversableResolver;
import ru.vyarus.dropwizard.orient.internal.EmbeddedOrientServer;
import ru.vyarus.dropwizard.orient.support.ConsoleCommand;
import ru.vyarus.dropwizard.orient.support.OrientServlet;

public class OrientServerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private final Logger logger = LoggerFactory.getLogger(OrientServerBundle.class);
    private final Class<T> configClass;

    public OrientServerBundle(Class<T> configClass) {
        this.configClass = configClass;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.recoverValidatorBehaviour(bootstrap);
        bootstrap.addCommand(new ConsoleCommand<T>(this.configClass));
    }

    public void run(T configuration, Environment environment) throws Exception {
        OrientServerConfiguration conf = ((HasOrientServerConfiguration)configuration).getOrientServerConfiguration();
        if (conf == null || !conf.isStart()) {
            this.logger.debug("Orient server start disabled. Set 'start: true' in configuration to enable.");
            return;
        }
        EmbeddedOrientServer orientServer = new EmbeddedOrientServer(conf);
        environment.lifecycle().manage((Managed)orientServer);
        environment.healthChecks().register("orient-server", (HealthCheck)new OrientServerHealthCheck());
        if (conf.isAdminServlet()) {
            environment.getAdminContext().addServlet((ServletHolder)new NonblockingServletHolder((Servlet)new OrientServlet(orientServer.getServerInfo())), "/orient/*");
        }
    }

    private void recoverValidatorBehaviour(Bootstrap<?> bootstrap) {
        this.logger.debug("Replacing TraversableResolver to fix hibernate validator");
        ValidatorFactoryImpl factory = (ValidatorFactoryImpl)bootstrap.getValidatorFactory();
        try {
            Field field = factory.getClass().getDeclaredField("traversableResolver");
            field.setAccessible(true);
            field.set(factory, new DummyTraversableResolver());
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to substitute traversableResolver", e);
        }
    }
}

