/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.orient.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import java.io.File;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientServerConfiguration {
    private final Logger logger = LoggerFactory.getLogger(OrientServerConfiguration.class);
    @NotEmpty
    private String filesPath;
    private boolean start = true;
    private String configFile;
    private boolean adminServlet = true;
    @NotNull
    private OServerConfiguration config;

    public boolean isStart() {
        return this.start;
    }

    @JsonProperty
    public void setStart(boolean start) {
        this.start = start;
    }

    public String getFilesPath() {
        return this.filesPath;
    }

    @JsonProperty(value="files-path")
    public void setFilesPath(String filesPath) {
        this.filesPath = this.parseDbPath(filesPath);
    }

    @JsonProperty(value="config-file")
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
        this.config = this.parseXmlConfigFile(configFile);
    }

    public boolean isAdminServlet() {
        return this.adminServlet;
    }

    @JsonProperty(value="admin-servlet")
    public void setAdminServlet(boolean adminServlet) {
        this.adminServlet = adminServlet;
    }

    public OServerConfiguration getConfig() {
        return this.config;
    }

    @JsonProperty
    public void setConfig(OServerConfiguration config) {
        Preconditions.checkState((this.config == null ? 1 : 0) != 0, (Object)("Orient configuration already loaded from file '" + this.configFile + "'. Use either xml file or direct yaml config, but not both."));
        this.config = config;
    }

    private OServerConfiguration parseXmlConfigFile(String configFile) {
        this.logger.info("Loading orient configuration from file {}", (Object)configFile);
        OServerConfigurationLoaderXml configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, new File(configFile));
        try {
            return configurationLoader.load();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load configuration from file: " + configFile, e);
        }
    }

    private String parseDbPath(String path) {
        String trimmedPath = Strings.emptyToNull((String)path);
        return trimmedPath == null ? null : trimmedPath.replace("$TMP", System.getProperty("java.io.tmpdir"));
    }
}

