/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.orient.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetStaticContent;
import io.dropwizard.lifecycle.Managed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.orient.configuration.OrientServerConfiguration;
import ru.vyarus.dropwizard.orient.internal.OrientStudioInstaller;

public class EmbeddedOrientServer
implements Managed {
    private final Logger logger = LoggerFactory.getLogger(EmbeddedOrientServer.class);
    private final OrientServerConfiguration conf;
    private final Info serverInfo = new Info();

    public EmbeddedOrientServer(OrientServerConfiguration conf) {
        this.validateConfiguration(conf);
        this.conf = conf;
    }

    public void start() throws Exception {
        OServerCommandGetStaticContent command;
        System.setProperty("ORIENTDB_HOME", this.conf.getFilesPath());
        System.setProperty("orientdb.www.path", "");
        OServer server = OServerMain.create();
        server.startup(this.conf.getConfig()).activate();
        String studioVersion = null;
        OServerNetworkListener httpListener = server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (httpListener != null && (command = (OServerCommandGetStaticContent)httpListener.getCommand(OServerCommandGetStaticContent.class)) != null) {
            studioVersion = new OrientStudioInstaller(command).install();
        }
        this.fillServerInfo(server, studioVersion);
        this.logger.info("Orient server started");
    }

    public void stop() throws Exception {
        OServerMain.server().shutdown();
        this.logger.info("Orient server stopped");
    }

    public Info getServerInfo() {
        return this.serverInfo;
    }

    private void validateConfiguration(OrientServerConfiguration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration object required");
        Preconditions.checkNotNull((Object)conf.getConfig(), (Object)"Orient server configuration required");
        Preconditions.checkState((conf.getConfig().getUser("root") != null ? 1 : 0) != 0, (String)"User '%s' must be defined in configuration because otherwise orient will ask for user password on each application start.", (Object[])new Object[]{"root"});
    }

    private void fillServerInfo(OServer server, String studioVersion) {
        OServerNetworkListener binaryListener;
        this.serverInfo.studioVersion = studioVersion;
        OServerNetworkListener httpListener = server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (httpListener != null) {
            this.serverInfo.httpPort = String.valueOf(httpListener.getInboundAddr().getPort());
        }
        if ((binaryListener = server.getListenerByProtocol(ONetworkProtocolBinary.class)) != null) {
            this.serverInfo.binaryPort = String.valueOf(binaryListener.getInboundAddr().getPort());
        }
    }

    public static class Info {
        public String studioVersion;
        public String httpPort;
        public String binaryPort;
    }
}

