/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.orient.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetStaticContent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientStudioInstaller {
    public static final String STUDIO_WEBJAR_CONFIG = "/META-INF/maven/org.webjars/orientdb-studio/pom.properties";
    public static final String STUDIO_WEBJAR_PATH_BASE = "/META-INF/resources/webjars/orientdb-studio/";
    private final Logger logger = LoggerFactory.getLogger(OrientStudioInstaller.class);
    private final OServerCommandGetStaticContent command;

    public OrientStudioInstaller(OServerCommandGetStaticContent command) {
        this.command = command;
    }

    public String install() throws Exception {
        String studioVersion = this.getStudioVersion();
        if (studioVersion != null) {
            this.registerStudio(studioVersion);
        }
        return studioVersion;
    }

    private void registerStudio(String studioVersion) throws Exception {
        this.logger.debug("Registering studio application");
        final String studioPath = STUDIO_WEBJAR_PATH_BASE + studioVersion + "/";
        this.command.registerVirtualFolder("studio", (OCallable)new OCallable<Object, String>(){

            public Object call(String iArgument) {
                String fileName = studioPath + (String)MoreObjects.firstNonNull((Object)Strings.emptyToNull((String)iArgument), (Object)"index.htm");
                URL url = this.getClass().getResource(fileName);
                if (url != null) {
                    OServerCommandGetStaticContent.OStaticContent content = new OServerCommandGetStaticContent.OStaticContent();
                    content.is = new BufferedInputStream(this.getClass().getResourceAsStream(fileName));
                    content.contentSize = -1L;
                    content.type = OServerCommandGetStaticContent.getContentType((String)url.getFile());
                    return content;
                }
                return null;
            }
        });
    }

    private String getStudioVersion() throws IOException {
        URL studioConfig = this.getClass().getResource(STUDIO_WEBJAR_CONFIG);
        String res = null;
        if (studioConfig != null) {
            Properties props = new Properties();
            try (InputStream propsStream = this.getClass().getResourceAsStream(STUDIO_WEBJAR_CONFIG);){
                props.load(propsStream);
                res = props.getProperty("version");
            }
        }
        return res;
    }
}

