/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.orient.support;

import com.google.common.collect.Lists;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import io.dropwizard.Configuration;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import ru.vyarus.dropwizard.orient.configuration.HasOrientServerConfiguration;
import ru.vyarus.dropwizard.orient.configuration.OrientServerConfiguration;

public class ConsoleCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    public static final String COMMANDS_ARG = "commands";
    private Class<T> configClass;

    public ConsoleCommand(Class<T> configClass) {
        this(configClass, "console");
    }

    public ConsoleCommand(Class<T> configClass, String commandName) {
        super(commandName, "Run orient db console");
        this.configClass = configClass;
    }

    protected Class<T> getConfigurationClass() {
        return this.configClass;
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{COMMANDS_ARG}).nargs("*").help("orient console commands or commands file");
    }

    protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        OrientServerConfiguration conf = ((HasOrientServerConfiguration)configuration).getOrientServerConfiguration();
        List commands = (List)namespace.get(COMMANDS_ARG);
        this.printHelp(conf, commands);
        OConsoleDatabaseApp.main((String[])commands.toArray(new String[commands.size()]));
    }

    private void printHelp(OrientServerConfiguration conf, List<String> commands) {
        System.out.println("See details of command usage: http://www.orientechnologies.com/docs/last/orientdb.wiki/Console-Commands.html");
        if (conf == null) {
            return;
        }
        boolean isInteractiveMode = commands.isEmpty();
        String dbFolder = (conf.getFilesPath() + "/databases/").replaceAll("//", "/");
        List<String> availableDatabases = this.getDatabases(dbFolder);
        if (isInteractiveMode && !availableDatabases.isEmpty()) {
            System.out.println("To connect database use one of the following commands:");
            for (String db : availableDatabases) {
                if (conf.isStart()) {
                    System.out.println(String.format("$ connect remote:localhost/%s root root", db));
                }
                System.out.println(String.format("$ connect plocal:%s root root", this.cleanupDbPath(dbFolder, db)));
            }
        }
    }

    private List<String> getDatabases(String dbFolder) {
        File[] files;
        ArrayList availableDatabases = Lists.newArrayList();
        File file = new File(dbFolder);
        if (file.exists() && file.isDirectory() && (files = file.listFiles()) != null) {
            for (File db : files) {
                if (!db.isDirectory()) continue;
                availableDatabases.add(db.getName());
            }
        }
        return availableDatabases;
    }

    private String cleanupDbPath(String basedir, String name) {
        String res = basedir + name;
        try {
            res = new File(res).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }
}

