/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.orient.support;

import com.google.common.base.MoreObjects;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.vyarus.dropwizard.orient.internal.EmbeddedOrientServer;

public class OrientServlet
extends HttpServlet {
    public static final String STUDIO_URI = "/studio";
    private static final long serialVersionUID = -2850794040708785320L;
    private static final String DISABLED = "disabled";
    private static final String CONF_DYNAMIC_PLUGIN = "plugin.dynamic";
    private static final String CONF_PLUGIN_RELOAD = "plugin.hotReload";
    private static final String CONF_PROFILER = "profiler.enabled";
    private static final String TEMPLATE = String.format("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"%n        \"http://www.w3.org/TR/html4/loose.dtd\">%n<html>%n<head>%n  <title>OrientDB</title>%n</head>%n<body>%n  <h1>Embedded OrientDB server</h1>%n  <ul>%n    <li>Version: {0}</li>%n    <li>Binary port: {1}</li>%n    <li>Http port: {2}</li>%n    <li><a href=\"{3}\" target=\"_blank\">Studio webjar</a>: {4}</li>%n    <li>Plugins: {5}</li>%n    <li>Dynamic plugins: {6} (hot reload: {7})</li>%n    <li>Profiler: {8}</li>%n  </ul>%n  {9}%n</body>%n</html>", new Object[0]);
    private static final String LINKS_TEMPLATE = String.format("  <h2>Links</h2>%n  <ul>%n    <li><a href=\"{0}/studio\">Embedded studio</a></li>%n  </ul>%n  <ul>%n    <li><a href=\"{1}\" {2}>Documentation</a>%n    <ul>%n        <li><a href=\"{1}DB-Server.html#configuration\" {2}>Server</a></li>%n        <li><a href=\"{1}Commands.html\" {2}>Sql commands</a></li>%n        <li><a href=\"{1}SQL-Functions.html#bundled-functions\" {2}>Sql functions</a></li>%n        <li><a href=\"{1}SQL-Methods.html\" {2}>Sql methods</a></li>%n        <li><a href=\"{1}Query-Examples.html\" {2}>Query examples</a></li>%n        <li><a href=\"{1}Console-Commands.html#console-commands\" {2}>Console commands</a></li>%n        <li><a href=\"{1}OrientDB-REST.html\" {2}>Rest api</a></li>%n    </ul></li>%n  </ul>", new Object[0]);
    private final transient EmbeddedOrientServer.Info info;

    public OrientServlet(EmbeddedOrientServer.Info info) {
        this.info = info;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getPathInfo();
        if (STUDIO_URI.equals(uri)) {
            resp.sendRedirect(String.format("http://%s:%s/studio/index.htm", req.getServerName(), this.info.httpPort));
        } else {
            super.service(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getContextPath() + req.getServletPath();
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setContentType("text/html");
        try (PrintWriter writer = resp.getWriter();){
            OContextConfiguration config = OServerMain.server().getContextConfiguration();
            writer.println(MessageFormat.format(TEMPLATE, "2.0.12", MoreObjects.firstNonNull((Object)this.info.binaryPort, (Object)DISABLED), MoreObjects.firstNonNull((Object)this.info.httpPort, (Object)DISABLED), "http://search.maven.org/#search%7Cgav%7C1%7Cg%3A%22org.webjars%22%20AND%20a%3A%22orientdb-studio%22", this.info.studioVersion, this.renderPlugins(config), config.getValueAsString(CONF_DYNAMIC_PLUGIN, null), config.getValueAsString(CONF_PLUGIN_RELOAD, null), config.getValueAsString(CONF_PROFILER, null), this.renderLinks(path)));
        }
    }

    private String renderLinks(String path) {
        return MessageFormat.format(LINKS_TEMPLATE, path, "http://orientdb.com/docs/last/", "target=\"_blank\"");
    }

    private String renderPlugins(OContextConfiguration config) {
        String pluginsEnabled = config.getValueAsString(CONF_DYNAMIC_PLUGIN, null);
        StringBuilder installedPlugins = new StringBuilder();
        if (pluginsEnabled != null) {
            Collection plugins = OServerMain.server().getPlugins();
            if (!plugins.isEmpty()) {
                installedPlugins.append("<ul>");
                for (OServerPluginInfo plugin : plugins) {
                    installedPlugins.append(String.format("<li>%s</li>", plugin.getName()));
                }
                installedPlugins.append("</ul>");
            } else {
                installedPlugins.append("none");
            }
        }
        return installedPlugins.toString();
    }
}

