/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.quality.service;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Task;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFinishEvent;
import ru.vyarus.gradle.plugin.quality.ConfigLoader;
import ru.vyarus.gradle.plugin.quality.QualityExtension;
import ru.vyarus.gradle.plugin.quality.QualityPlugin;
import ru.vyarus.gradle.plugin.quality.report.CheckstyleReporter;
import ru.vyarus.gradle.plugin.quality.report.CodeNarcReporter;
import ru.vyarus.gradle.plugin.quality.report.CpdReporter;
import ru.vyarus.gradle.plugin.quality.report.HtmlReportGenerator;
import ru.vyarus.gradle.plugin.quality.report.PmdReporter;
import ru.vyarus.gradle.plugin.quality.report.Reporter;
import ru.vyarus.gradle.plugin.quality.report.SpotbugsReporter;
import ru.vyarus.gradle.plugin.quality.util.DurationFormatter;

public abstract class TasksListenerService
implements BuildService<BuildServiceParameters.None>,
OperationCompletionListener,
GroovyObject {
    private final Map<String, Reporter> reporters;
    private final Map<String, TaskDesc> targetTasks;
    private QualityExtension extension;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public TasksListenerService() {
        MetaClass metaClass;
        Map map;
        this.reporters = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ConcurrentHashMap<String, TaskDesc> concurrentHashMap = new ConcurrentHashMap<String, TaskDesc>();
        this.targetTasks = concurrentHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init(ConfigLoader loader, QualityExtension extension) {
        QualityExtension qualityExtension;
        this.extension = qualityExtension = extension;
        CheckstyleReporter checkstyleReporter = new CheckstyleReporter();
        ScriptBytecodeAdapter.invokeMethodN(TasksListenerService.class, this.reporters, (String)"putAt", (Object[])new Object[]{QualityPlugin.TOOL_CHECKSTYLE, checkstyleReporter});
        CodeNarcReporter codeNarcReporter = new CodeNarcReporter();
        ScriptBytecodeAdapter.invokeMethodN(TasksListenerService.class, this.reporters, (String)"putAt", (Object[])new Object[]{QualityPlugin.TOOL_CODENARC, codeNarcReporter});
        CpdReporter cpdReporter = new CpdReporter(loader);
        ScriptBytecodeAdapter.invokeMethodN(TasksListenerService.class, this.reporters, (String)"putAt", (Object[])new Object[]{QualityPlugin.TOOL_CPD, cpdReporter});
        PmdReporter pmdReporter = new PmdReporter();
        ScriptBytecodeAdapter.invokeMethodN(TasksListenerService.class, this.reporters, (String)"putAt", (Object[])new Object[]{QualityPlugin.TOOL_PMD, pmdReporter});
        SpotbugsReporter spotbugsReporter = new SpotbugsReporter();
        ScriptBytecodeAdapter.invokeMethodN(TasksListenerService.class, this.reporters, (String)"putAt", (Object[])new Object[]{QualityPlugin.TOOL_SPOTBUGS, spotbugsReporter});
    }

    public void register(Task task, String type, boolean useFullTaskName) {
        Reference task2 = new Reference((Object)task);
        String string = ((Task)task2.get()).getPath();
        TaskDesc taskDesc = new TaskDesc();
        Task task3 = (Task)task2.get();
        taskDesc.setTask(task3);
        String string2 = type;
        taskDesc.setType(string2);
        boolean bl = useFullTaskName;
        taskDesc.setUseFullTaskName(bl);
        this.targetTasks.put(string, taskDesc);
        public final class _register_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _register_closure1(Object _outerInstance, Object _thisObject, Reference task) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.task = reference = task;
            }

            public Object doCall(Object it) {
                ((TasksListenerService)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), TasksListenerService.class)).execute(((Task)this.task.get()).getPath());
                return null;
            }

            @Generated
            public Task getTask() {
                return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _register_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Task)task2.get()).doLast((Closure)new _register_closure1(this, this, task2));
        ((Reporter)DefaultGroovyMethods.getAt(this.reporters, (Object)type)).init((Task)task2.get());
    }

    public void onFinish(FinishEvent finishEvent) {
        if (finishEvent instanceof TaskFinishEvent) {
            TaskFinishEvent taskEvent = (TaskFinishEvent)ScriptBytecodeAdapter.castToType((Object)finishEvent, TaskFinishEvent.class);
            this.execute(taskEvent.getDescriptor().getTaskPath());
        }
    }

    public synchronized void execute(String taskPath) {
        TaskDesc desc = (TaskDesc)ScriptBytecodeAdapter.castToType((Object)this.targetTasks.get(taskPath), TaskDesc.class);
        if (desc != null && !desc.isExecuted()) {
            boolean bl = true;
            desc.setExecuted(bl);
            this.reportTask(desc.getTask(), desc.getType(), (Reporter)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.reporters, (Object)desc.getType()), Reporter.class), desc.isUseFullTaskName());
        }
    }

    private void reportTask(Task task, String type, Reporter reporter, boolean useFullTaskName) {
        boolean generatesHtmlReport = this.extension.getHtmlReports() && HtmlReportGenerator.class.isAssignableFrom(reporter.getClass());
        if (!this.extension.getConsoleReporting() && !generatesHtmlReport) {
            return;
        }
        String taskType = useFullTaskName ? task.getName() : StringGroovyMethods.getAt((String)task.getName(), (IntRange)new IntRange(true, type.length(), -1)).toLowerCase();
        if (generatesHtmlReport) {
            ((HtmlReportGenerator)ScriptBytecodeAdapter.asType((Object)reporter, HtmlReportGenerator.class)).generateHtmlReport(task, taskType);
        }
        if (this.extension.getConsoleReporting()) {
            long start = System.currentTimeMillis();
            reporter.report(task, taskType);
            String duration = DurationFormatter.format(System.currentTimeMillis() - start);
            task.getProject().getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{type, duration}, new String[]{"[plugin:quality] ", " reporting executed in ", ""})));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TasksListenerService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TasksListenerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TasksListenerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TasksListenerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, TasksListenerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(TasksListenerService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static class TaskDesc
    implements GroovyObject {
        private Task task;
        private String type;
        private boolean useFullTaskName;
        private boolean executed;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public TaskDesc() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TaskDesc.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TaskDesc.class, TasksListenerService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Task getTask() {
            return this.task;
        }

        @Generated
        public void setTask(Task task) {
            this.task = task;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String string) {
            this.type = string;
        }

        @Generated
        public boolean getUseFullTaskName() {
            return this.useFullTaskName;
        }

        @Generated
        public boolean isUseFullTaskName() {
            return this.useFullTaskName;
        }

        @Generated
        public void setUseFullTaskName(boolean bl) {
            this.useFullTaskName = bl;
        }

        @Generated
        public boolean getExecuted() {
            return this.executed;
        }

        @Generated
        public boolean isExecuted() {
            return this.executed;
        }

        @Generated
        public void setExecuted(boolean bl) {
            this.executed = bl;
        }
    }
}

