/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.vm.TeaVMOptimizationLevel;
import ru.vyarus.gradle.plugin.teavm.DevOptions;
import ru.vyarus.gradle.plugin.teavm.TeavmExtension;
import ru.vyarus.gradle.plugin.teavm.task.TeavmCompileTask;
import ru.vyarus.gradle.plugin.teavm.util.ClasspathBuilder;
import ru.vyarus.gradle.plugin.teavm.util.FsUtils;
import ru.vyarus.gradle.plugin.teavm.util.SourcesBuilder;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
public class TeavmPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TeavmExtension extension = (TeavmExtension)project.getExtensions().create("teavm", TeavmExtension.class, new Object[]{project});
        this.registerConfiguration(project, extension);
        this.registerShortcuts(project);
        this.configureTask(project, extension);
        this.configureResourcesMix(project, extension);
    }

    private void registerConfiguration(Project project, TeavmExtension extension) {
        project.getConfigurations().create("teavm", conf -> {
            conf.attributes(attrs -> attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime"))));
            conf.setDescription("TeaVM compiler classpath");
            conf.setTransitive(true);
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
            conf.defaultDependencies(dependencies -> {
                String auto;
                String version = extension.getVersion();
                boolean detected = false;
                if (extension.isAutoVersion() && (auto = this.autoDetectVersion(project, extension.getConfigurations())) != null) {
                    version = auto;
                    detected = true;
                }
                project.getLogger().lifecycle("TeaVM compiler version: {}{}", new Object[]{version, detected ? " (auto-detected)" : ""});
                dependencies.add((Object)project.getDependencies().create((Object)("org.teavm:teavm-cli:" + extension.getVersion())));
            });
        });
    }

    private void registerShortcuts(Project project) {
        ExtraPropertiesExtension extraProps = project.getExtensions().getExtraProperties();
        extraProps.set(TeavmCompileTask.class.getSimpleName(), TeavmCompileTask.class);
        Arrays.asList(TeaVMTargetType.values()).forEach(type -> extraProps.set(type.name(), type));
        Arrays.asList(WasmBinaryVersion.values()).forEach(type -> extraProps.set(type.name(), type));
        Arrays.asList(TeaVMOptimizationLevel.values()).forEach(type -> extraProps.set(type.name(), type));
    }

    private void configureTask(Project project, TeavmExtension extension) {
        project.getTasks().register("compileTeavm", TeavmCompileTask.class);
        project.getTasks().withType(TeavmCompileTask.class).configureEach(task -> {
            task.getDebug().set((Object)extension.isDebug());
            DevOptions options = extension.isDev() ? extension.getDevOptions() : extension;
            ClasspathBuilder cp = new ClasspathBuilder(project, extension.isDebug(), extension.getSourceSets(), extension.getConfigurations(), extension.getExtraClassDirs());
            task.getClassPath().convention(cp.getDirectories());
            cp.dependencies(task.getDependencies());
            if (options.isSourceFilesCopied()) {
                SourcesBuilder src = new SourcesBuilder(project, extension.isDebug(), extension.getSourceSets(), extension.getConfigurations(), extension.getExtraSourceDirs());
                src.resolveSources();
                task.getSources().convention(src.getSourceDirs());
                src.dependencies(task.getSourceDependencies());
            }
            task.getTargetDir().convention(FsUtils.dir(project, extension.getTargetDir()));
            task.getCacheDir().convention(FsUtils.dir(project, extension.getCacheDir()));
            task.getMainClass().convention((Object)extension.getMainClass());
            task.getEntryPointName().convention((Object)extension.getEntryPointName());
            task.getTargetFileName().convention((Object)extension.getTargetFileName());
            task.getTargetType().convention((Object)extension.getTargetType());
            task.getWasmVersion().convention((Object)extension.getWasmVersion());
            task.getStopOnErrors().convention((Object)extension.isStopOnErrors());
            this.configureDevOptions((TeavmCompileTask)((Object)task), options);
            task.getMaxTopLevelNames().convention((Object)extension.getMaxTopLevelNames());
            task.getMinHeapSize().convention((Object)extension.getMinHeapSize());
            task.getMaxHeapSize().convention((Object)extension.getMaxHeapSize());
            task.getTransformers().convention(extension.getTransformers());
            task.getProperties().convention(extension.getProperties());
            task.getClassesToPreserve().convention(extension.getClassesToPreserve());
            Task compileJava = project.getTasks().findByPath("classes");
            if (compileJava != null) {
                task.dependsOn(new Object[]{compileJava});
            }
        });
    }

    private void configureDevOptions(TeavmCompileTask task, DevOptions options) {
        task.getObfuscated().convention((Object)options.isObfuscated());
        task.getStrict().convention((Object)options.isStrict());
        task.getSourceFilesCopied().convention((Object)options.isSourceFilesCopied());
        task.getIncremental().convention((Object)options.isIncremental());
        task.getDebugInformationGenerated().convention((Object)options.isDebugInformationGenerated());
        task.getSourceMapsGenerated().convention((Object)options.isSourceMapsGenerated());
        task.getShortFileNames().convention((Object)options.isShortFileNames());
        task.getLongjmpSupported().convention((Object)options.isLongjmpSupported());
        task.getHeapDump().convention((Object)options.isHeapDump());
        task.getFastDependencyAnalysis().convention((Object)options.isFastDependencyAnalysis());
        task.getOptimizationLevel().convention((Object)options.getOptimizationLevel());
    }

    private void configureResourcesMix(Project project, TeavmExtension extension) {
        project.afterEvaluate(p -> {
            if (extension.isMixedResources()) {
                ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
                    if (extension.getSourceSets().contains(sourceSet.getName())) {
                        Set files = sourceSet.getAllJava().getSourceDirectories().getFiles();
                        project.getTasks().withType(ProcessResources.class).configureEach(task -> task.from((Object)files, copySpec -> copySpec.exclude(new String[]{"**/*.java"}).exclude(new String[]{"**/*.kt"}).exclude(new String[]{"**/*.scala"})));
                        if (extension.isDebug()) {
                            System.out.println("Mixed resources mode for source set '" + sourceSet.getName() + "': \n" + files.stream().map(file -> "\t" + file.getAbsolutePath().replace(project.getProjectDir().getAbsolutePath() + File.separator, "")).collect(Collectors.joining("\n")));
                        }
                    }
                });
            }
        });
    }

    private String autoDetectVersion(Project project, List<String> configurations) {
        String version = null;
        for (String cf : configurations) {
            Optional<ResolvedArtifact> tvm = project.getConfigurations().getByName(cf).getResolvedConfiguration().getResolvedArtifacts().stream().filter(art -> "teavm-classlib".equals(art.getName())).findFirst();
            if (!tvm.isPresent()) continue;
            Properties props = FsUtils.readMavenProperties(tvm.get().getFile(), "META-INF/maven/org.teavm/teavm-classlib/pom.properties");
            if (props == null) break;
            version = props.getProperty("version");
            break;
        }
        return version;
    }
}

