/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;

public class SourcesBuilder {
    private final Project project;
    private final boolean debug;
    private final List<String> sourceSets;
    private final List<String> configurations;
    private final Set<String> extraSourceDirs;
    private final List<Directory> sourceDirs = new ArrayList<Directory>();
    private final List<File> sourceJars = new ArrayList<File>();

    public SourcesBuilder(Project project, boolean debug, List<String> sourceSets, List<String> configurations, Set<String> extraSourceDirs) {
        this.project = project;
        this.debug = debug;
        this.sourceSets = sourceSets;
        this.configurations = configurations;
        this.extraSourceDirs = extraSourceDirs;
    }

    public void resolveSources() {
        if (!this.sourceSets.isEmpty()) {
            this.resolveSourceSetSources();
        }
        if (this.debug && !this.extraSourceDirs.isEmpty()) {
            System.out.println("Extra source directories: \n" + this.extraSourceDirs.stream().map(s -> "\t" + this.project.file(s).getAbsolutePath().replace(this.project.getRootDir().getAbsolutePath() + File.separator, "")).sorted().collect(Collectors.joining("\n")));
        }
        for (String dir : this.extraSourceDirs) {
            this.sourceDirs.add(this.project.getLayout().getProjectDirectory().dir(dir));
            File dirFile = this.project.file((Object)dir);
            File[] jars = dirFile.listFiles(file -> file.getName().toLowerCase().endsWith(".jar"));
            if (jars == null || jars.length <= 0) continue;
            if (this.debug) {
                System.out.println("Source jars from extra directory '" + dirFile.getAbsolutePath().replace(this.project.getRootDir().getAbsolutePath() + File.separator, "") + "': \n" + Arrays.stream(jars).map(s -> "\t" + String.format("%-50s  %s", s.getName(), s.getAbsolutePath().replace(dirFile.getAbsolutePath() + File.separator, ""))).sorted().collect(Collectors.joining("\n")));
            }
            Collections.addAll(this.sourceJars, jars);
        }
        this.resolveDependencySources();
    }

    public List<Directory> getSourceDirs() {
        return this.sourceDirs;
    }

    public void dependencies(ConfigurableFileCollection files) {
        files.from(new Object[]{this.sourceJars});
    }

    private void resolveSourceSetSources() {
        ((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
            if (this.sourceSets.contains(sourceSet.getName())) {
                ArrayList<Directory> sources = new ArrayList<Directory>();
                for (File file : sourceSet.getAllSource().getSourceDirectories().getFiles()) {
                    sources.add(this.project.getLayout().getProjectDirectory().dir(file.getAbsolutePath()));
                }
                if (!sources.isEmpty()) {
                    if (this.debug) {
                        System.out.println("'" + sourceSet.getName() + "' source set sources: \n" + sources.stream().map(s -> "\t" + s.getAsFile().getAbsolutePath().replace(this.project.getProjectDir().getAbsolutePath() + File.separator, "")).sorted().collect(Collectors.joining("\n")));
                    }
                    this.sourceDirs.addAll(sources);
                }
            }
        });
    }

    private void resolveDependencySources() {
        for (String config : this.configurations) {
            Set allDeps = this.project.getConfigurations().getByName(config).getResolvedConfiguration().getResolvedArtifacts();
            ArtifactResolutionResult result = this.project.getDependencies().createArtifactResolutionQuery().forComponents((Iterable)allDeps.stream().map(dep -> dep.getId().getComponentIdentifier()).collect(Collectors.toSet())).withArtifacts(JvmLibrary.class, new Class[]{SourcesArtifact.class}).execute();
            ArrayList sourceArtifacts = new ArrayList();
            result.getResolvedComponents().forEach(component -> component.getArtifacts(SourcesArtifact.class).forEach(artifactResult -> {
                if (artifactResult instanceof ResolvedArtifactResult) {
                    sourceArtifacts.add(((ResolvedArtifactResult)artifactResult).getFile());
                }
            }));
            if (this.debug && !sourceArtifacts.isEmpty()) {
                System.out.println("Resolved source artifacts for configuration'" + config + "': \n" + sourceArtifacts.stream().map(s -> "\t" + String.format("%-50s  %s", s.getName(), s.getAbsolutePath())).sorted().collect(Collectors.joining("\n")));
            }
            this.sourceJars.addAll(sourceArtifacts);
        }
    }
}

