/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.Nested;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.vm.TeaVMOptimizationLevel;
import ru.vyarus.gradle.plugin.teavm.DevOptions;

public class TeavmExtension
extends DevOptions {
    private boolean dev = false;
    private boolean debug = false;
    private boolean mixedResources = false;
    private boolean autoVersion = true;
    private String version = "0.7.0";
    private List<String> sourceSets = new ArrayList<String>(Arrays.asList("main", "kotlin", "scala"));
    private List<String> configurations = new ArrayList<String>(Collections.singletonList("runtimeClasspath"));
    private Set<String> extraClassDirs = new HashSet<String>();
    private Set<String> extraSourceDirs = new HashSet<String>();
    private String targetDir;
    private String cacheDir;
    private String mainClass;
    private String entryPointName = "main";
    private String targetFileName = "";
    private TeaVMTargetType targetType = TeaVMTargetType.JAVASCRIPT;
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    private boolean stopOnErrors = true;
    private int maxTopLevelNames = 10000;
    private int minHeapSize = 4;
    private int maxHeapSize = 128;
    private List<String> transformers = null;
    private Map<String, String> properties = null;
    private List<String> classesToPreserve;
    private final DevOptions devOptions = new DevOptions();

    public TeavmExtension(Project project) {
        String buildDir = project.relativePath((Object)project.getBuildDir());
        this.targetDir = buildDir + "/teavm";
        this.cacheDir = buildDir + "/teavm-cache";
        this.devOptions.setObfuscated(false);
        this.devOptions.setStrict(false);
        this.devOptions.setSourceFilesCopied(true);
        this.devOptions.setIncremental(false);
        this.devOptions.setDebugInformationGenerated(true);
        this.devOptions.setSourceMapsGenerated(true);
        this.devOptions.setFastDependencyAnalysis(false);
        this.devOptions.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
        this.devOptions.setLongjmpSupported(true);
        this.devOptions.setShortFileNames(false);
        this.devOptions.setHeapDump(false);
    }

    public boolean isDev() {
        return this.dev;
    }

    public void setDev(boolean dev) {
        this.dev = dev;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isMixedResources() {
        return this.mixedResources;
    }

    public void setMixedResources(boolean mixedResources) {
        this.mixedResources = mixedResources;
    }

    public boolean isAutoVersion() {
        return this.autoVersion;
    }

    public void setAutoVersion(boolean autoVersion) {
        this.autoVersion = autoVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getSourceSets() {
        return this.sourceSets;
    }

    public void setSourceSets(List<String> sourceSets) {
        this.sourceSets = sourceSets;
    }

    public Set<String> getExtraClassDirs() {
        return this.extraClassDirs;
    }

    public void setExtraClassDirs(Set<String> extraClassDirs) {
        this.extraClassDirs = extraClassDirs;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<String> configurations) {
        this.configurations = configurations;
    }

    public Set<String> getExtraSourceDirs() {
        return this.extraSourceDirs;
    }

    public void setExtraSourceDirs(Set<String> extraSourceDirs) {
        this.extraSourceDirs = extraSourceDirs;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getEntryPointName() {
        return this.entryPointName;
    }

    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public TeaVMTargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TeaVMTargetType targetType) {
        this.targetType = targetType;
    }

    public WasmBinaryVersion getWasmVersion() {
        return this.wasmVersion;
    }

    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.wasmVersion = wasmVersion;
    }

    public boolean isStopOnErrors() {
        return this.stopOnErrors;
    }

    public void setStopOnErrors(boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    public int getMaxTopLevelNames() {
        return this.maxTopLevelNames;
    }

    public void setMaxTopLevelNames(int maxTopLevelNames) {
        this.maxTopLevelNames = maxTopLevelNames;
    }

    public int getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(int minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<String> transformers) {
        this.transformers = transformers;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public List<String> getClassesToPreserve() {
        return this.classesToPreserve;
    }

    public void setClassesToPreserve(List<String> classesToPreserve) {
        this.classesToPreserve = classesToPreserve;
    }

    @Nested
    public DevOptions getDevOptions() {
        return this.devOptions;
    }

    public void devOptions(Action<DevOptions> action) {
        action.execute((Object)this.getDevOptions());
    }
}

