/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm.util;

import java.math.BigDecimal;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public final class DurationFormatter {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_DAY = 86400000L;

    private DurationFormatter() {
    }

    public static String format(long duration) {
        long remain = duration;
        if (remain == 0L) {
            return "0ms";
        }
        StringBuilder result = new StringBuilder();
        long days = remain / 86400000L;
        remain %= 86400000L;
        if (days > 0L) {
            DurationFormatter.append(result, days, "d");
        }
        long hours = remain / 3600000L;
        remain %= 3600000L;
        if (hours > 0L) {
            DurationFormatter.append(result, hours, "h");
        }
        long minutes = remain / 60000L;
        remain %= 60000L;
        if (minutes > 0L) {
            DurationFormatter.append(result, minutes, "m");
        }
        boolean secs = false;
        if (remain >= 1000L) {
            int secondsScale = result.length() == 0 ? 2 : 0;
            DurationFormatter.append(result, BigDecimal.valueOf(remain).divide(BigDecimal.valueOf(1000L)).setScale(secondsScale, 4).stripTrailingZeros().toPlainString(), "s");
            secs = true;
            remain %= 1000L;
        }
        if (!secs && remain > 0L) {
            result.append(StringGroovyMethods.plus((Number)remain, (String)"ms"));
        }
        return result.toString();
    }

    private static void append(StringBuilder builder, Object num, String what) {
        if (builder.length() > 0) {
            builder.append(' ');
        }
        builder.append(num).append(what);
    }
}

