/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm.util;

import java.io.File;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;

public final class FsUtils {
    private FsUtils() {
    }

    public static Directory dir(Project project, String dir) {
        return project.getLayout().getProjectDirectory().dir(dir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties readMavenProperties(File jar, String path) {
        try (ZipFile file = new ZipFile(jar);){
            ZipEntry entry = file.getEntry(path);
            if (entry == null) {
                System.err.println("Maven properties file not found inside " + jar.getName() + ": " + path);
                Properties properties = null;
                return properties;
            }
            Properties props = new Properties();
            props.load(file.getInputStream(entry));
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            throw new IllegalStateException("Maven properties resolution failed in jar " + jar.getAbsolutePath(), e);
        }
    }
}

