/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.vm.TeaVMOptimizationLevel;
import ru.vyarus.gradle.plugin.teavm.task.CompileWorker;

public abstract class TeavmCompileTask
extends DefaultTask {
    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Console
    public abstract Property<Boolean> getDebug();

    @InputFiles
    public abstract SetProperty<Directory> getClassPath();

    @Classpath
    public abstract ConfigurableFileCollection getDependencies();

    @InputFiles
    @Optional
    public abstract SetProperty<Directory> getSources();

    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getSourceDependencies();

    @OutputDirectory
    public abstract DirectoryProperty getTargetDir();

    @Internal
    public abstract DirectoryProperty getCacheDir();

    @Input
    public abstract Property<String> getMainClass();

    @Input
    @Optional
    public abstract Property<String> getEntryPointName();

    @Input
    @Optional
    public abstract Property<String> getTargetFileName();

    @Input
    public abstract Property<TeaVMTargetType> getTargetType();

    @Input
    public abstract Property<WasmBinaryVersion> getWasmVersion();

    @Input
    public abstract Property<Boolean> getStopOnErrors();

    @Input
    public abstract Property<Boolean> getObfuscated();

    @Input
    public abstract Property<Boolean> getStrict();

    @Input
    public abstract Property<Boolean> getSourceFilesCopied();

    @Input
    public abstract Property<Boolean> getIncremental();

    @Input
    public abstract Property<Boolean> getDebugInformationGenerated();

    @Input
    public abstract Property<Boolean> getSourceMapsGenerated();

    @Input
    public abstract Property<Boolean> getShortFileNames();

    @Input
    public abstract Property<Boolean> getLongjmpSupported();

    @Input
    public abstract Property<Boolean> getHeapDump();

    @Input
    public abstract Property<Boolean> getFastDependencyAnalysis();

    @Input
    public abstract Property<Boolean> getAssertionsRemoved();

    @Input
    public abstract Property<Integer> getMaxTopLevelNames();

    @Input
    public abstract Property<Integer> getMinHeapSize();

    @Input
    public abstract Property<Integer> getMaxHeapSize();

    @Input
    public abstract Property<TeaVMOptimizationLevel> getOptimizationLevel();

    @Input
    @Optional
    public abstract ListProperty<String> getTransformers();

    @Input
    @Optional
    public abstract MapProperty<String, String> getProperties();

    @Input
    @Optional
    public abstract ListProperty<String> getClassesToPreserve();

    @TaskAction
    public void compile() {
        WorkQueue workQueue = this.getWorkerExecutor().classLoaderIsolation(workerSpec -> {
            Configuration teavmConf = this.getProject().getConfigurations().getByName("teavm");
            workerSpec.getClasspath().from(new Object[]{teavmConf});
        });
        File resultFile = ((RegularFile)this.getProject().getLayout().getBuildDirectory().file(this.getName() + ".error").get()).getAsFile();
        if (resultFile.exists()) {
            FileUtils.deleteQuietly((File)resultFile);
        }
        this.runCompilation(workQueue, resultFile);
        if (((Boolean)this.getStopOnErrors().get()).booleanValue() && resultFile.exists()) {
            String errors = null;
            try {
                errors = Files.readString(resultFile.toPath());
                errors = Arrays.stream(errors.split("\n")).map(s -> "\t" + s).collect(Collectors.joining("\n"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileUtils.deleteQuietly((File)resultFile);
            throw new GradleException("Teavm compilation failed" + (String)(errors == null ? "" : ":\n\n" + errors + "\n"));
        }
        if (resultFile.exists()) {
            FileUtils.deleteQuietly((File)resultFile);
        }
    }

    private void runCompilation(WorkQueue workQueue, File resultFile) {
        workQueue.submit(CompileWorker.class, parameters -> {
            parameters.getDebug().set(this.getDebug());
            ArrayList classpath = new ArrayList();
            classpath.addAll(((Set)this.getClassPath().get()).stream().map(s -> s.getAsFile().getAbsolutePath()).collect(Collectors.toList()));
            classpath.addAll(this.getDependencies().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            parameters.getClassPathEntries().set(classpath);
            parameters.getSourceDirectories().set(this.getSources());
            parameters.getSourceJars().set((Iterable)this.getSourceDependencies().getFiles());
            parameters.getTargetDirectory().set((Provider)this.getTargetDir());
            parameters.getCacheDirectory().set((Provider)this.getCacheDir());
            parameters.getMainClass().set(this.getMainClass());
            parameters.getEntryPointName().set(this.getEntryPointName());
            parameters.getTargetFileName().set(this.getTargetFileName());
            parameters.getTargetType().set(this.getTargetType());
            parameters.getWasmVersion().set(this.getWasmVersion());
            parameters.getObfuscated().set(this.getObfuscated());
            parameters.getStrict().set(this.getStrict());
            parameters.getSourceFilesCopied().set(this.getSourceFilesCopied());
            parameters.getIncremental().set(this.getIncremental());
            parameters.getDebugInformationGenerated().set(this.getDebugInformationGenerated());
            parameters.getSourceMapsFileGenerated().set(this.getSourceMapsGenerated());
            parameters.getShortFileNames().set(this.getShortFileNames());
            parameters.getLongjmpSupported().set(this.getLongjmpSupported());
            parameters.getHeapDump().set(this.getHeapDump());
            parameters.getFastDependencyAnalysis().set(this.getFastDependencyAnalysis());
            parameters.getAssertionsRemoved().set(this.getAssertionsRemoved());
            parameters.getMaxTopLevelNames().set(this.getMaxTopLevelNames());
            parameters.getMinHeapSize().set(this.getMinHeapSize());
            parameters.getMaxHeapSize().set(this.getMaxHeapSize());
            parameters.getOptimizationLevel().set(this.getOptimizationLevel());
            parameters.getTransformers().set(this.getTransformers());
            parameters.getProperties().set(this.getProperties());
            parameters.getClassesToPreserve().set(this.getClassesToPreserve());
            parameters.getErrorFile().set(resultFile);
        });
        workQueue.await();
    }
}

