/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.SourceSetContainer;

public class ClasspathBuilder {
    private final Project project;
    private final boolean debug;
    private final List<String> sourceSets;
    private final Set<String> extraClassDirs;
    private final List<String> configurations;

    public ClasspathBuilder(Project project, boolean debug, List<String> sourceSets, List<String> configurations, Set<String> extraClassDirs) {
        this.project = project;
        this.debug = debug;
        this.sourceSets = sourceSets;
        this.configurations = configurations;
        this.extraClassDirs = extraClassDirs;
    }

    public List<Directory> getDirectories() {
        ArrayList<Directory> res = new ArrayList<Directory>();
        if (!this.sourceSets.isEmpty()) {
            ((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
                if (this.sourceSets.contains(sourceSet.getName())) {
                    List collect = sourceSet.getOutput().getFiles().stream().map(s -> this.project.getLayout().getProjectDirectory().dir(s.getAbsolutePath())).collect(Collectors.toList());
                    if (this.debug) {
                        System.out.println("'" + sourceSet.getName() + "' source set classes: \n" + collect.stream().map(s -> "\t" + s.getAsFile().getAbsolutePath().replace(this.project.getProjectDir().getAbsolutePath() + File.separator, "")).sorted().collect(Collectors.joining("\n")));
                    }
                    res.addAll(collect);
                }
            });
        }
        ArrayList<Directory> extras = new ArrayList<Directory>();
        for (String dir : this.extraClassDirs) {
            extras.add(this.project.getLayout().getProjectDirectory().dir(dir));
        }
        if (!extras.isEmpty()) {
            if (this.debug) {
                System.out.println("Extra class directories: \n" + extras.stream().map(s -> "\t" + s.getAsFile().getAbsolutePath().replace(this.project.getProjectDir().getAbsolutePath() + File.separator, "")).sorted().collect(Collectors.joining("\n")));
            }
            res.addAll(extras);
        }
        return res;
    }

    public void dependencies(ConfigurableFileCollection files) {
        for (String config : this.configurations) {
            ArrayList jars = new ArrayList(this.project.getConfigurations().getByName(config).getFiles());
            if (jars.isEmpty()) continue;
            if (this.debug) {
                System.out.println("'" + config + "' configuration jars: \n" + jars.stream().map(s -> "\t" + String.format("%-50s  %s", s.getName(), s.getAbsolutePath())).sorted().collect(Collectors.joining("\n")));
            }
            files.from(new Object[]{jars});
        }
    }
}

