/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.teavm.task;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.workers.WorkAction;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.tooling.builder.BuildStrategy;
import org.teavm.tooling.builder.InProcessBuildStrategy;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;
import ru.vyarus.gradle.plugin.teavm.task.CompileParameters;
import ru.vyarus.gradle.plugin.teavm.util.DurationFormatter;

public abstract class CompileWorker
implements WorkAction<CompileParameters> {
    public void execute() {
        InProcessBuildStrategy build = new InProcessBuildStrategy();
        this.configure((BuildStrategy)build);
        build.setProgressListener((TeaVMProgressListener)new LogListener());
        build.setLog((TeaVMToolLog)new LogDelegate());
        try {
            this.run((BuildStrategy)build);
        }
        catch (Exception ex) {
            System.err.println("Unexpected compilation error");
            ex.printStackTrace();
            this.indicateFail("Unexpected processing error: \n" + ex.getMessage());
        }
    }

    private void configure(BuildStrategy build) {
        build.setClassPathEntries((List)((CompileParameters)this.getParameters()).getClassPathEntries().get());
        build.setObfuscated(((Boolean)((CompileParameters)this.getParameters()).getObfuscated().get()).booleanValue());
        build.setStrict(((Boolean)((CompileParameters)this.getParameters()).getStrict().get()).booleanValue());
        build.setMaxTopLevelNames(((Integer)((CompileParameters)this.getParameters()).getMaxTopLevelNames().get()).intValue());
        build.setTargetDirectory(((Directory)((CompileParameters)this.getParameters()).getTargetDirectory().get()).getAsFile().getAbsolutePath());
        if (((CompileParameters)this.getParameters()).getTransformers().isPresent()) {
            build.setTransformers(((List)((CompileParameters)this.getParameters()).getTransformers().get()).toArray(new String[0]));
        }
        if (((Boolean)((CompileParameters)this.getParameters()).getSourceFilesCopied().get()).booleanValue()) {
            build.setSourceFilesCopied(true);
            ((List)((CompileParameters)this.getParameters()).getSourceDirectories().get()).forEach(directory -> build.addSourcesDirectory(directory.getAsFile().getAbsolutePath()));
            ((List)((CompileParameters)this.getParameters()).getSourceJars().get()).forEach(jar -> build.addSourcesJar(jar.getAbsolutePath()));
        }
        if (((CompileParameters)this.getParameters()).getProperties().isPresent()) {
            Properties res = new Properties();
            res.putAll((Map<?, ?>)((Map)((CompileParameters)this.getParameters()).getProperties().get()));
            build.setProperties(res);
        }
        build.setIncremental(((Boolean)((CompileParameters)this.getParameters()).getIncremental().get()).booleanValue());
        build.setDebugInformationGenerated(((Boolean)((CompileParameters)this.getParameters()).getDebugInformationGenerated().get()).booleanValue());
        build.setSourceMapsFileGenerated(((Boolean)((CompileParameters)this.getParameters()).getSourceMapsFileGenerated().get()).booleanValue());
        build.setMinHeapSize((Integer)((CompileParameters)this.getParameters()).getMinHeapSize().get() * 1024 * 1024);
        build.setMaxHeapSize((Integer)((CompileParameters)this.getParameters()).getMaxHeapSize().get() * 1024 * 1024);
        build.setShortFileNames(((Boolean)((CompileParameters)this.getParameters()).getShortFileNames().get()).booleanValue());
        build.setAssertionsRemoved(((Boolean)((CompileParameters)this.getParameters()).getAssertionsRemoved().get()).booleanValue());
        build.setMainClass((String)((CompileParameters)this.getParameters()).getMainClass().get());
        build.setEntryPointName((String)((CompileParameters)this.getParameters()).getEntryPointName().getOrNull());
        build.setTargetFileName((String)((CompileParameters)this.getParameters()).getTargetFileName().getOrNull());
        build.setOptimizationLevel((TeaVMOptimizationLevel)((CompileParameters)this.getParameters()).getOptimizationLevel().get());
        build.setFastDependencyAnalysis(((Boolean)((CompileParameters)this.getParameters()).getFastDependencyAnalysis().get()).booleanValue());
        if (((CompileParameters)this.getParameters()).getClassesToPreserve().isPresent()) {
            build.setClassesToPreserve(((List)((CompileParameters)this.getParameters()).getClassesToPreserve().get()).toArray(new String[0]));
        }
        build.setCacheDirectory(((Directory)((CompileParameters)this.getParameters()).getCacheDirectory().get()).getAsFile().getAbsolutePath());
        build.setTargetType((TeaVMTargetType)((CompileParameters)this.getParameters()).getTargetType().get());
        build.setWasmVersion((WasmBinaryVersion)((CompileParameters)this.getParameters()).getWasmVersion().get());
        build.setHeapDump(((Boolean)((CompileParameters)this.getParameters()).getHeapDump().get()).booleanValue());
    }

    private void run(BuildStrategy build) throws Exception {
        long watch = System.currentTimeMillis();
        BuildResult result = build.build();
        long time = System.currentTimeMillis() - watch;
        if (result.getProblems() != null) {
            LogDelegate log = new LogDelegate(true);
            TeaVMProblemRenderer.describeProblems((CallGraph)result.getCallGraph(), (ProblemProvider)result.getProblems(), (TeaVMToolLog)log);
            if (!result.getProblems().getSevereProblems().isEmpty()) {
                this.indicateFail(String.join((CharSequence)"\n\n", log.getErrors()));
            }
        }
        if (result.getProblems() == null || result.getProblems().getSevereProblems().isEmpty()) {
            System.out.println("Resources used: " + result.getUsedResources().size());
            if (((Boolean)((CompileParameters)this.getParameters()).getDebug().get()).booleanValue()) {
                System.out.println(result.getUsedResources().stream().map(s -> "\t" + s).sorted().collect(Collectors.joining("\n")));
                System.out.println("Generated files: " + result.getGeneratedFiles().size());
                System.out.println(result.getGeneratedFiles().stream().map(s -> "\t" + s.replace(((Directory)((CompileParameters)this.getParameters()).getTargetDirectory().get()).getAsFile().getAbsolutePath() + File.separator, "") + " (" + FileUtils.byteCountToDisplaySize((long)new File((String)s).length()) + ")").sorted().collect(Collectors.joining("\n ")));
            }
            System.out.println("Overall time: " + DurationFormatter.format(time));
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void indicateFail(String message) {
        try {
            File file = ((RegularFile)((CompileParameters)this.getParameters()).getErrorFile().get()).getAsFile();
            file.createNewFile();
            Files.writeString(file.toPath(), (CharSequence)message, new OpenOption[0]);
        }
        catch (IOException ex) {
            System.err.println("Error creating marker file");
            ex.printStackTrace();
        }
    }

    public static class LogDelegate
    implements TeaVMToolLog {
        private final boolean collectErrors;
        private final List<String> errors = new ArrayList<String>();

        public LogDelegate() {
            this(false);
        }

        public LogDelegate(boolean collectErrors) {
            this.collectErrors = collectErrors;
        }

        public void info(String s) {
            System.out.println("\r" + s);
        }

        public void info(String s, Throwable throwable) {
            System.out.println("\r" + s);
            throwable.printStackTrace();
        }

        public void debug(String s) {
            System.out.println("\r" + s);
        }

        public void debug(String s, Throwable throwable) {
            System.out.println("\r" + s);
            throwable.printStackTrace();
        }

        public void warning(String s) {
            System.out.println("\rWARNING: " + s);
        }

        public void warning(String s, Throwable throwable) {
            System.out.println("\rWARNING: " + s);
            throwable.printStackTrace();
        }

        public void error(String s) {
            System.out.println("\rERROR: " + s);
            if (this.collectErrors) {
                this.errors.add(s);
            }
        }

        public void error(String s, Throwable throwable) {
            System.err.println("\rERROR: " + s);
            throwable.printStackTrace();
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }

    public static class LogListener
    implements TeaVMProgressListener {
        private TeaVMPhase currentPhase;
        private int target = 1;
        private long timer;

        public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int maxSteps) {
            if (this.timer > 0L && this.currentPhase != null) {
                this.phaseDone();
            }
            this.currentPhase = phase;
            this.target = maxSteps == 0 ? 1 : maxSteps;
            this.timer = System.currentTimeMillis();
            return TeaVMProgressFeedback.CONTINUE;
        }

        public TeaVMProgressFeedback progressReached(int stepsReached) {
            if (stepsReached == this.target) {
                this.phaseDone();
                this.timer = 0L;
            } else {
                int current = stepsReached == 0 ? 1 : stepsReached;
                int total = this.target == 1 ? 1000 : this.target;
                StringBuilder string = new StringBuilder(140);
                int percent = current * 100 / total;
                string.append('\r').append(this.currentPhase).append(' ').append(String.join((CharSequence)"", Collections.nCopies(percent == 0 ? 2 : 2 - (int)Math.log10(percent), " "))).append(String.format(" %d%% [", percent)).append(String.join((CharSequence)"", Collections.nCopies(percent, "="))).append('>').append(String.join((CharSequence)"", Collections.nCopies(100 - percent, " "))).append(']').append(String.join((CharSequence)"", Collections.nCopies((int)Math.log10(total) - (int)Math.log10(current), " "))).append(String.format(" %d/%d", stepsReached, this.target));
                System.out.print(string);
            }
            return TeaVMProgressFeedback.CONTINUE;
        }

        private void phaseDone() {
            System.out.printf("\r\t %-40s %s%n", this.currentPhase, DurationFormatter.format(System.currentTimeMillis() - this.timer));
        }
    }
}

