/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.core.field;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import ru.vyarus.guice.ext.core.field.FieldPostProcessor;
import ru.vyarus.guice.ext.core.util.Utils;

public class AnnotatedFieldTypeListener<T extends Annotation>
implements TypeListener {
    private Class<T> annotationClass;
    private FieldPostProcessor<T> postProcessor;

    public AnnotatedFieldTypeListener(Class<T> annotationClass, FieldPostProcessor<T> postProcessor) {
        this.annotationClass = annotationClass;
        this.postProcessor = postProcessor;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class actualType = type.getRawType();
        if (!Utils.isPackageValid(actualType)) {
            return;
        }
        for (Class investigatingType = actualType; investigatingType != null && !investigatingType.equals(Object.class); investigatingType = investigatingType.getSuperclass()) {
            for (final Field field : investigatingType.getDeclaredFields()) {
                if (!field.isAnnotationPresent(this.annotationClass)) continue;
                encounter.register(new InjectionListener<I>(){

                    public void afterInjection(I injectee) {
                        try {
                            field.setAccessible(true);
                            AnnotatedFieldTypeListener.this.postProcessor.process(field.getAnnotation(AnnotatedFieldTypeListener.this.annotationClass), field, injectee);
                        }
                        catch (Exception ex) {
                            throw new IllegalStateException(String.format("Failed to process annotation %s on field %s of class %s", AnnotatedFieldTypeListener.this.annotationClass.getSimpleName(), field.getName(), injectee.getClass().getSimpleName()), ex);
                        }
                    }
                });
            }
        }
    }
}

