/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import ru.vyarus.guice.ext.core.field.AnnotatedFieldTypeListener;
import ru.vyarus.guice.ext.core.method.AnnotatedMethodTypeListener;
import ru.vyarus.guice.ext.core.type.GeneralTypeListener;
import ru.vyarus.guice.ext.core.util.ObjectPackageMatcher;
import ru.vyarus.guice.ext.log.Log;
import ru.vyarus.guice.ext.log.Slf4jLogAnnotationProcessor;
import ru.vyarus.guice.ext.managed.DestroyableTypeProcessor;
import ru.vyarus.guice.ext.managed.PostConstructAnnotationProcessor;
import ru.vyarus.guice.ext.managed.PreDestroyAnnotationProcessor;
import ru.vyarus.guice.ext.managed.destroyable.Destroyable;
import ru.vyarus.guice.ext.managed.destroyable.DestroyableManager;

public class ExtAnnotationsModule
extends AbstractModule {
    private Matcher<Object> typeMatcher;

    public ExtAnnotationsModule() {
        this((Matcher<Object>)Matchers.any());
    }

    public ExtAnnotationsModule(String pkg) {
        this((Matcher<Object>)new ObjectPackageMatcher(pkg));
    }

    public ExtAnnotationsModule(Matcher<Object> typeMatcher) {
        this.typeMatcher = typeMatcher;
    }

    protected void configure() {
        DestroyableManager manager = this.configureManager(new DestroyableManager());
        this.bindListener(this.typeMatcher, new GeneralTypeListener<Destroyable>(Destroyable.class, new DestroyableTypeProcessor(manager)));
        this.bindListener(this.typeMatcher, new AnnotatedMethodTypeListener<PostConstruct>(PostConstruct.class, new PostConstructAnnotationProcessor()));
        this.bindListener(this.typeMatcher, new AnnotatedMethodTypeListener<PreDestroy>(PreDestroy.class, new PreDestroyAnnotationProcessor(manager)));
        this.bindListener(this.typeMatcher, new AnnotatedFieldTypeListener<Log>(Log.class, new Slf4jLogAnnotationProcessor()));
    }

    protected DestroyableManager configureManager(DestroyableManager manager) {
        this.bind(DestroyableManager.class).toInstance((Object)manager);
        Runtime.getRuntime().addShutdownHook(new Thread(manager));
        return manager;
    }
}

