/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.core.type;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import ru.vyarus.guice.ext.core.type.TypePostProcessor;
import ru.vyarus.guice.ext.core.util.Utils;

public class GeneralTypeListener<T>
implements TypeListener {
    private Class<T> typeClass;
    private TypePostProcessor<T> postProcessor;

    public GeneralTypeListener(Class<T> typeClass, TypePostProcessor<T> postProcessor) {
        this.typeClass = typeClass;
        this.postProcessor = postProcessor;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class actualType = type.getRawType();
        if (!Utils.isPackageValid(actualType)) {
            return;
        }
        if (this.checkType(actualType)) {
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    try {
                        GeneralTypeListener.this.postProcessor.process(injectee);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException(String.format("Failed to process type %s of class %s", GeneralTypeListener.this.typeClass.getSimpleName(), injectee.getClass().getSimpleName()), ex);
                    }
                }
            });
        }
    }

    private boolean checkType(Class<?> check) {
        if (check.isAssignableFrom(this.typeClass)) {
            return true;
        }
        if (this.typeClass.isInterface()) {
            for (Class<T> investigating = check; investigating != null && !investigating.equals(Object.class); investigating = investigating.getSuperclass()) {
                for (Class<?> test : investigating.getInterfaces()) {
                    if (!test.equals(this.typeClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

