/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.managed.destroyable;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guice.ext.managed.destroyable.Destroyable;

public class DestroyableManager
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(DestroyableManager.class);
    private List<Destroyable> destroyListeners = new ArrayList<Destroyable>();

    public void register(Destroyable destroyable) {
        this.destroyListeners.add(destroyable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        DestroyableManager destroyableManager = this;
        synchronized (destroyableManager) {
            for (Destroyable destroyable : this.destroyListeners) {
                try {
                    destroyable.preDestroy();
                }
                catch (Exception ex) {
                    this.logger.error("Failed to properly destroy bean", (Throwable)ex);
                }
            }
            this.destroyListeners.clear();
        }
    }

    @Override
    public void run() {
        this.destroy();
    }
}

