/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.internal.ContextualCallable;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import javax.inject.Inject;
import ru.vyarus.guice.ext.core.generator.DynamicClassGenerator;

public class DynamicClassProvider
implements Provider<Object> {
    private final Injector injector;

    @Inject
    public DynamicClassProvider(Injector injector) {
        this.injector = injector;
    }

    public Object get() {
        try {
            return ((InjectorImpl)this.injector).callInContext((ContextualCallable)new ContextualCallable<Object>(){

                public Object call(InternalContext context) {
                    Class abstractType = context.getDependency().getKey().getTypeLiteral().getRawType();
                    Class generatedType = DynamicClassGenerator.generate(abstractType);
                    return DynamicClassProvider.this.injector.getInstance(generatedType);
                }
            });
        }
        catch (ErrorsException e) {
            throw new ProvisionException((Iterable)e.getErrors().getMessages());
        }
    }
}

