/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.core.generator;

import com.google.common.base.Preconditions;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.internal.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import ru.vyarus.guice.ext.core.generator.AnnotationMemberValueVisitor;
import ru.vyarus.guice.ext.core.generator.DynamicClassException;
import ru.vyarus.guice.ext.core.generator.ScopeAnnotation;

public final class DynamicClassGenerator {
    public static final String DYNAMIC_CLASS_POSTFIX = "$GuiceDynamicClass";

    private DynamicClassGenerator() {
    }

    public static <T> Class<T> generate(Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"Original type required");
        Preconditions.checkArgument((type.isInterface() || Modifier.isAbstract(type.getModifiers()) ? 1 : 0) != 0, (String)"Type must be interface or abstract class, but provided type is not: %s", (Object[])new Object[]{type.getName()});
        try {
            Class targetClass;
            String targetClassName = type.getName() + DYNAMIC_CLASS_POSTFIX;
            ClassPool pool = ClassPool.getDefault();
            if (pool.getOrNull(targetClassName) == null) {
                CtClass impl = DynamicClassGenerator.generateClass(targetClassName, type);
                targetClass = impl.toClass(type.getClassLoader(), null);
            } else {
                targetClass = Class.forName(targetClassName);
            }
            return targetClass;
        }
        catch (Exception ex) {
            throw new DynamicClassException("Failed to generate class for " + type.getName(), ex);
        }
    }

    private static CtClass generateClass(String targetClassName, Class type) throws Exception {
        CtClass impl;
        ClassPool pool = ClassPool.getDefault();
        CtClass ctType = pool.get(type.getName());
        if (type.isInterface()) {
            impl = pool.makeClass(targetClassName);
            impl.addInterface(ctType);
        } else {
            impl = pool.makeClass(targetClassName, ctType);
            DynamicClassGenerator.copyConstructor(impl, type);
        }
        impl.getClassFile().addAttribute((AttributeInfo)DynamicClassGenerator.copyAnnotations(impl.getClassFile().getConstPool(), type));
        return impl;
    }

    private static void copyConstructor(CtClass impl, Class type) throws Exception {
        Constructor ctor = DynamicClassGenerator.findDIConstructor(type);
        if (ctor != null) {
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])DynamicClassGenerator.convertTypes(ctor.getParameterTypes()), (CtClass[])DynamicClassGenerator.convertTypes(ctor.getExceptionTypes()), (int)2, null, null, (CtClass)impl);
            ConstPool constPool = impl.getClassFile().getConstPool();
            MethodInfo methodInfo = ctConstructor.getMethodInfo();
            methodInfo.addAttribute((AttributeInfo)DynamicClassGenerator.copyAnnotations(constPool, ctor));
            methodInfo.addAttribute((AttributeInfo)DynamicClassGenerator.copyConstructorParametersAnnotations(constPool, ctor));
            impl.addConstructor(ctConstructor);
        }
    }

    private static Constructor findDIConstructor(Class type) {
        Constructor<?> target = null;
        for (Constructor<?> ctor : type.getConstructors()) {
            if (!ctor.isAnnotationPresent(Inject.class) && !ctor.isAnnotationPresent(Inject.class)) continue;
            target = ctor;
            break;
        }
        return target;
    }

    private static ParameterAnnotationsAttribute copyConstructorParametersAnnotations(ConstPool constPool, Constructor ctor) throws Exception {
        int count = ctor.getParameterTypes().length;
        ParameterAnnotationsAttribute paramAnns = new ParameterAnnotationsAttribute(constPool, "RuntimeVisibleParameterAnnotations");
        javassist.bytecode.annotation.Annotation[][] paramAnnotations = new javassist.bytecode.annotation.Annotation[count][];
        for (int i = 0; i < count; ++i) {
            Annotation[] anns = ctor.getParameterAnnotations()[i];
            paramAnnotations[i] = new javassist.bytecode.annotation.Annotation[anns.length];
            for (int j = 0; j < anns.length; ++j) {
                paramAnnotations[i][j] = DynamicClassGenerator.copyAnnotation(paramAnns.getConstPool(), anns[j]);
            }
        }
        paramAnns.setAnnotations((javassist.bytecode.annotation.Annotation[][])paramAnnotations);
        return paramAnns;
    }

    private static CtClass[] convertTypes(Class<?> ... types) throws Exception {
        ClassPool pool = ClassPool.getDefault();
        CtClass[] resTypes = new CtClass[types.length];
        for (int i = 0; i < resTypes.length; ++i) {
            Class<?> type = types[i];
            resTypes[i] = pool.get(type.getName());
        }
        return resTypes;
    }

    private static AnnotationsAttribute copyAnnotations(ConstPool constPool, AnnotatedElement source) throws Exception {
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        if (source.getAnnotations().length > 0) {
            for (Annotation ann : source.getAnnotations()) {
                javassist.bytecode.annotation.Annotation annotation = DynamicClassGenerator.processAnnotation(constPool, ann);
                if (annotation == null) continue;
                attr.addAnnotation(annotation);
            }
        }
        return attr;
    }

    private static javassist.bytecode.annotation.Annotation processAnnotation(ConstPool constPool, Annotation ann) throws Exception {
        javassist.bytecode.annotation.Annotation res = null;
        if (!(ann instanceof ProvidedBy) && !(ann instanceof ImplementedBy)) {
            Preconditions.checkState((!Annotations.isScopeAnnotation(ann.annotationType()) ? 1 : 0) != 0, (Object)"Don't use scope annotations directly - use @ScopeAnnotation(TargetScope) wrapper, because guice doesn't allow scope annotations on abstract types");
            res = ann instanceof ScopeAnnotation ? new javassist.bytecode.annotation.Annotation(constPool, ClassPool.getDefault().get(((ScopeAnnotation)ann).value().getName())) : DynamicClassGenerator.copyAnnotation(constPool, ann);
        }
        return res;
    }

    private static javassist.bytecode.annotation.Annotation copyAnnotation(ConstPool constPool, Annotation ann) throws Exception {
        Method[] methods;
        ClassPool pool = ClassPool.getDefault();
        Class<? extends Annotation> annotationType = ann.annotationType();
        javassist.bytecode.annotation.Annotation copy = new javassist.bytecode.annotation.Annotation(annotationType.getName(), constPool);
        for (Method method : methods = annotationType.getDeclaredMethods()) {
            CtClass ctType = pool.get(method.getReturnType().getName());
            MemberValue memberValue = javassist.bytecode.annotation.Annotation.createMemberValue((ConstPool)constPool, (CtClass)ctType);
            Object value = method.invoke((Object)ann, new Object[0]);
            memberValue.accept((MemberValueVisitor)new AnnotationMemberValueVisitor(constPool, value));
            copy.addMemberValue(method.getName(), memberValue);
        }
        return copy;
    }
}

