/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.core.generator;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class AnnotationMemberValueVisitor
implements MemberValueVisitor {
    private static final Map<Class<?>, CtClass> PRIMITIVES = ImmutableMap.builder().put(Boolean.TYPE, (Object)CtClass.booleanType).put(Boolean.class, (Object)CtClass.booleanType).put(Byte.TYPE, (Object)CtClass.byteType).put(Byte.class, (Object)CtClass.byteType).put(Character.TYPE, (Object)CtClass.charType).put(Character.class, (Object)CtClass.charType).put(Short.TYPE, (Object)CtClass.shortType).put(Short.class, (Object)CtClass.shortType).put(Integer.TYPE, (Object)CtClass.intType).put(Integer.class, (Object)CtClass.intType).put(Long.TYPE, (Object)CtClass.longType).put(Long.class, (Object)CtClass.longType).put(Float.TYPE, (Object)CtClass.floatType).put(Float.class, (Object)CtClass.floatType).put(Double.TYPE, (Object)CtClass.doubleType).put(Double.class, (Object)CtClass.doubleType).build();
    private final ConstPool constPool;
    private final Object value;

    public AnnotationMemberValueVisitor(ConstPool constPool, Object value) {
        this.constPool = constPool;
        this.value = value;
    }

    public void visitAnnotationMemberValue(AnnotationMemberValue mb) {
        Class<?> annotationType = this.getClass(this.value);
        Method[] methods = annotationType.getDeclaredMethods();
        try {
            for (Method method : methods) {
                Object result = method.invoke(this.value, new Object[0]);
                mb.getValue().addMemberValue(method.getName(), this.createValue(result));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy annotation value", e);
        }
    }

    public void visitArrayMemberValue(ArrayMemberValue mb) {
        int length = Array.getLength(this.value);
        MemberValue[] members = new MemberValue[length];
        try {
            for (int i = 0; i < length; ++i) {
                Object object = Array.get(this.value, i);
                members[i] = this.createValue(object);
            }
            mb.setValue(members);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy array value", e);
        }
    }

    public void visitBooleanMemberValue(BooleanMemberValue mb) {
        mb.setValue(((Boolean)this.value).booleanValue());
    }

    public void visitByteMemberValue(ByteMemberValue mb) {
        mb.setValue(((Byte)this.value).byteValue());
    }

    public void visitCharMemberValue(CharMemberValue mb) {
        mb.setValue(((Character)this.value).charValue());
    }

    public void visitDoubleMemberValue(DoubleMemberValue mb) {
        mb.setValue(((Double)this.value).doubleValue());
    }

    public void visitEnumMemberValue(EnumMemberValue mb) {
        Enum enumeration = (Enum)this.value;
        Class type = enumeration.getDeclaringClass();
        mb.setType(type.getName());
        mb.setValue(enumeration.name());
    }

    public void visitFloatMemberValue(FloatMemberValue mb) {
        mb.setValue(((Float)this.value).floatValue());
    }

    public void visitIntegerMemberValue(IntegerMemberValue mb) {
        mb.setValue(((Integer)this.value).intValue());
    }

    public void visitLongMemberValue(LongMemberValue mb) {
        mb.setValue(((Long)this.value).longValue());
    }

    public void visitShortMemberValue(ShortMemberValue mb) {
        mb.setValue(((Short)this.value).shortValue());
    }

    public void visitStringMemberValue(StringMemberValue mb) {
        mb.setValue((String)this.value);
    }

    public void visitClassMemberValue(ClassMemberValue mb) {
        mb.setValue(((Class)this.value).getName());
    }

    private MemberValue createValue(Object value) throws Exception {
        MemberValue memberValue = javassist.bytecode.annotation.Annotation.createMemberValue((ConstPool)this.constPool, (CtClass)AnnotationMemberValueVisitor.getCtClass(this.getClass(value)));
        memberValue.accept((MemberValueVisitor)new AnnotationMemberValueVisitor(this.constPool, value));
        return memberValue;
    }

    private Class<?> getClass(Object object) {
        boolean isAnnotation = object instanceof Annotation;
        return isAnnotation ? ((Annotation)object).annotationType() : object.getClass();
    }

    private static CtClass getCtClass(Class<?> type) throws Exception {
        return PRIMITIVES.containsKey(type) ? PRIMITIVES.get(type) : ClassPool.getDefault().get(type.getName());
    }
}

