/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.core.generator;

import com.google.common.base.Preconditions;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.internal.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import ru.vyarus.guice.ext.core.generator.DynamicClassException;
import ru.vyarus.guice.ext.core.generator.JavassistUtils;
import ru.vyarus.guice.ext.core.generator.ScopeAnnotation;

public final class DynamicClassGenerator {
    public static final String DYNAMIC_CLASS_POSTFIX = "$GuiceDynamicClass";

    private DynamicClassGenerator() {
    }

    public static <T> Class<T> generate(Class<T> type) {
        return DynamicClassGenerator.generate(type, null);
    }

    public static <T> Class<T> generate(Class<T> type, Class<? extends Annotation> scope) {
        Preconditions.checkNotNull(type, (Object)"Original type required");
        Preconditions.checkArgument((type.isInterface() || Modifier.isAbstract(type.getModifiers()) ? 1 : 0) != 0, (String)"Type must be interface or abstract class, but provided type is not: %s", (Object[])new Object[]{type.getName()});
        try {
            Class targetClass;
            String targetClassName = type.getName() + DYNAMIC_CLASS_POSTFIX;
            ClassPool pool = ClassPool.getDefault();
            if (pool.getOrNull(targetClassName) == null) {
                CtClass impl = DynamicClassGenerator.generateClass(targetClassName, type, scope);
                targetClass = impl.toClass(type.getClassLoader(), null);
            } else {
                targetClass = Class.forName(targetClassName);
            }
            return targetClass;
        }
        catch (Exception ex) {
            throw new DynamicClassException("Failed to generate class for " + type.getName(), ex);
        }
    }

    private static CtClass generateClass(String targetClassName, Class type, Class<? extends Annotation> scope) throws Exception {
        CtClass impl;
        ClassPool pool = ClassPool.getDefault();
        CtClass ctType = pool.get(type.getName());
        if (type.isInterface()) {
            impl = pool.makeClass(targetClassName);
            impl.addInterface(ctType);
        } else {
            impl = pool.makeClass(targetClassName, ctType);
            DynamicClassGenerator.copyConstructor(impl, type);
        }
        ConstPool constPool = impl.getClassFile().getConstPool();
        AnnotationsAttribute annotations = DynamicClassGenerator.copyAnnotations(constPool, type);
        impl.getClassFile().addAttribute((AttributeInfo)annotations);
        DynamicClassGenerator.applyScopeAnnotation(type, constPool, annotations, scope);
        return impl;
    }

    private static void copyConstructor(CtClass impl, Class type) throws Exception {
        Constructor ctor = DynamicClassGenerator.findDIConstructor(type);
        if (ctor != null) {
            CtClass[] parameters = JavassistUtils.convertTypes(ctor.getParameterTypes());
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])parameters, (CtClass[])JavassistUtils.convertTypes(ctor.getExceptionTypes()), (int)2, null, null, (CtClass)impl);
            ConstPool constPool = impl.getClassFile().getConstPool();
            MethodInfo methodInfo = ctConstructor.getMethodInfo();
            methodInfo.addAttribute((AttributeInfo)DynamicClassGenerator.copyAnnotations(constPool, ctor));
            methodInfo.addAttribute((AttributeInfo)DynamicClassGenerator.copyConstructorParametersAnnotations(constPool, ctor));
            SignatureAttribute info = DynamicClassGenerator.copyConstructorGenericsSignature(parameters, type, constPool);
            if (info != null) {
                methodInfo.addAttribute((AttributeInfo)info);
            }
            impl.addConstructor(ctConstructor);
        }
    }

    private static Constructor findDIConstructor(Class<?> type) {
        Constructor<?> target = null;
        for (Constructor<?> ctor : type.getConstructors()) {
            if (!ctor.isAnnotationPresent(Inject.class) && !ctor.isAnnotationPresent(javax.inject.Inject.class)) continue;
            target = ctor;
            break;
        }
        return target;
    }

    private static ParameterAnnotationsAttribute copyConstructorParametersAnnotations(ConstPool constPool, Constructor ctor) throws Exception {
        int count = ctor.getParameterTypes().length;
        ParameterAnnotationsAttribute paramAnns = new ParameterAnnotationsAttribute(constPool, "RuntimeVisibleParameterAnnotations");
        javassist.bytecode.annotation.Annotation[][] paramAnnotations = new javassist.bytecode.annotation.Annotation[count][];
        for (int i = 0; i < count; ++i) {
            Annotation[] anns = ctor.getParameterAnnotations()[i];
            paramAnnotations[i] = new javassist.bytecode.annotation.Annotation[anns.length];
            for (int j = 0; j < anns.length; ++j) {
                paramAnnotations[i][j] = JavassistUtils.copyAnnotation(paramAnns.getConstPool(), anns[j]);
            }
        }
        paramAnns.setAnnotations((javassist.bytecode.annotation.Annotation[][])paramAnnotations);
        return paramAnns;
    }

    private static void applyScopeAnnotation(AnnotatedElement source, ConstPool constPool, AnnotationsAttribute annotations, Class<? extends Annotation> scope) throws Exception {
        if (scope != null) {
            Preconditions.checkState((boolean)Annotations.isScopeAnnotation(scope), (String)"Provided annotation %s is not scope annotation", (Object[])new Object[]{scope.getSimpleName()});
            for (Annotation ann : source.getAnnotations()) {
                Preconditions.checkArgument((!(ann instanceof ScopeAnnotation) ? 1 : 0) != 0, (String)"Duplicate scope definition: scope is specified as %s and also defined in @ScopeAnnotation.", (Object[])new Object[]{scope.getSimpleName()});
            }
            annotations.addAnnotation(new javassist.bytecode.annotation.Annotation(constPool, ClassPool.getDefault().get(scope.getName())));
        }
    }

    private static AnnotationsAttribute copyAnnotations(ConstPool constPool, AnnotatedElement source) throws Exception {
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        if (source.getAnnotations().length > 0) {
            for (Annotation ann : source.getAnnotations()) {
                javassist.bytecode.annotation.Annotation annotation = DynamicClassGenerator.processAnnotation(constPool, ann);
                if (annotation == null) continue;
                attr.addAnnotation(annotation);
            }
        }
        return attr;
    }

    private static javassist.bytecode.annotation.Annotation processAnnotation(ConstPool constPool, Annotation ann) throws Exception {
        javassist.bytecode.annotation.Annotation res = null;
        if (!(ann instanceof ProvidedBy) && !(ann instanceof ImplementedBy)) {
            Preconditions.checkState((!Annotations.isScopeAnnotation(ann.annotationType()) ? 1 : 0) != 0, (Object)"Don't use scope annotations directly - use @ScopeAnnotation(TargetScope) wrapper, because guice doesn't allow scope annotations on abstract types");
            res = ann instanceof ScopeAnnotation ? new javassist.bytecode.annotation.Annotation(constPool, ClassPool.getDefault().get(((ScopeAnnotation)ann).value().getName())) : JavassistUtils.copyAnnotation(constPool, ann);
        }
        return res;
    }

    private static SignatureAttribute copyConstructorGenericsSignature(CtClass[] params, Class<?> type, ConstPool constPool) throws Exception {
        CtClass source = ClassPool.getDefault().get(type.getName());
        CtConstructor ctConstructor = source.getConstructor(Descriptor.ofConstructor((CtClass[])params));
        String signature = null;
        for (Object attr : ctConstructor.getMethodInfo().getAttributes()) {
            if (!(attr instanceof SignatureAttribute)) continue;
            signature = ((SignatureAttribute)attr).getSignature();
            break;
        }
        return signature == null ? null : new SignatureAttribute(constPool, signature);
    }
}

