/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.internal.ContextualCallable;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import ru.vyarus.guice.ext.core.generator.DynamicClassGenerator;
import ru.vyarus.guice.ext.core.generator.anchor.AnchorBean;

@Singleton
public class DynamicClassProvider
implements Provider<Object> {
    private final Injector injector;

    @Inject
    public DynamicClassProvider(Injector injector) {
        this.injector = injector;
    }

    public Object get() {
        try {
            return ((InjectorImpl)this.injector).callInContext((ContextualCallable)new ContextualCallable<Object>(){

                public Object call(InternalContext context) {
                    boolean hasAnchor = DynamicClassProvider.this.injector.getExistingBinding(Key.get(AnchorBean.class)) != null;
                    Class abstractType = context.getDependency().getKey().getTypeLiteral().getRawType();
                    Class generatedType = DynamicClassGenerator.generate(abstractType, DynamicClassProvider.this.getScopeAnnotation(), hasAnchor ? AnchorBean.class : null);
                    return DynamicClassProvider.this.injector.getInstance(generatedType);
                }
            });
        }
        catch (ErrorsException e) {
            throw new ProvisionException((Iterable)e.getErrors().getMessages());
        }
    }

    protected Class<? extends Annotation> getScopeAnnotation() {
        return null;
    }
}

