/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.ext.core.generator;

import com.google.common.base.Preconditions;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.internal.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import ru.vyarus.guice.ext.core.generator.DynamicClassException;
import ru.vyarus.guice.ext.core.generator.JavassistUtils;
import ru.vyarus.guice.ext.core.generator.ScopeAnnotation;

public final class DynamicClassGenerator {
    public static final String DYNAMIC_CLASS_POSTFIX = "$GuiceDynamicClass";

    private DynamicClassGenerator() {
    }

    public static <T> Class<T> generate(Class<T> type) {
        return DynamicClassGenerator.generate(type, null);
    }

    public static <T> Class<T> generate(Class<T> type, Class<? extends Annotation> scope) {
        return DynamicClassGenerator.generate(type, scope, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<T> generate(Class<T> type, Class<? extends Annotation> scope, Class<?> anchor) {
        Preconditions.checkNotNull(type, (Object)"Original type required");
        Preconditions.checkArgument((type.isInterface() || Modifier.isAbstract(type.getModifiers()) ? 1 : 0) != 0, (String)"Type must be interface or abstract class, but provided type is not: %s", (Object[])new Object[]{type.getName()});
        String targetClassName = type.getName() + DYNAMIC_CLASS_POSTFIX;
        ClassLoader classLoader = type.getClassLoader();
        Class<T> clazz = type;
        synchronized (clazz) {
            Class<?> targetClass;
            try {
                targetClass = classLoader.loadClass(targetClassName);
            }
            catch (ClassNotFoundException ex) {
                targetClass = DynamicClassGenerator.generateClass(type, targetClassName, classLoader, scope, anchor);
            }
            return targetClass;
        }
    }

    private static Class<?> generateClass(Class<?> type, String targetClassName, ClassLoader classLoader, Class<? extends Annotation> scope, Class<?> anchor) {
        try {
            ClassPool classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            CtClass impl = DynamicClassGenerator.generateCtClass(classPool, targetClassName, type, scope, anchor);
            return impl.toClass(classLoader, null);
        }
        catch (Exception ex) {
            throw new DynamicClassException("Failed to generate class for " + type.getName(), ex);
        }
    }

    private static CtClass generateCtClass(ClassPool classPool, String targetClassName, Class type, Class<? extends Annotation> scope, Class<?> anchor) throws Exception {
        CtClass impl;
        CtClass ctAnchor;
        CtClass ctType = classPool.get(type.getName());
        CtClass ctClass = ctAnchor = anchor == null ? null : classPool.getCtClass(anchor.getName());
        if (type.isInterface()) {
            impl = classPool.makeClass(targetClassName);
            impl.addInterface(ctType);
        } else {
            impl = classPool.makeClass(targetClassName, ctType);
            Constructor diConstructor = DynamicClassGenerator.findDIConstructor(type);
            if (diConstructor != null) {
                DynamicClassGenerator.copyConstructor(impl, ctType, diConstructor, ctAnchor);
            }
        }
        if (anchor != null && impl.getConstructors().length == 0) {
            DynamicClassGenerator.createAnchorConstructor(impl, ctAnchor);
        }
        ConstPool constPool = impl.getClassFile().getConstPool();
        AnnotationsAttribute annotations = DynamicClassGenerator.copyAnnotations(classPool, constPool, type);
        impl.getClassFile().addAttribute((AttributeInfo)annotations);
        DynamicClassGenerator.applyScopeAnnotation(classPool, annotations, type, scope);
        return impl;
    }

    private static void copyConstructor(CtClass impl, CtClass ctType, Constructor ctor, CtClass anchor) throws Exception {
        ClassPool classPool = impl.getClassPool();
        CtClass[] parameters = JavassistUtils.convertTypes(classPool, ctor.getParameterTypes());
        CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])parameters, (CtClass[])JavassistUtils.convertTypes(classPool, ctor.getExceptionTypes()), (int)2, null, null, (CtClass)impl);
        if (anchor != null) {
            ctConstructor.addParameter(anchor);
        }
        ConstPool constPool = impl.getClassFile().getConstPool();
        MethodInfo methodInfo = ctConstructor.getMethodInfo();
        methodInfo.addAttribute((AttributeInfo)DynamicClassGenerator.copyAnnotations(classPool, constPool, ctor));
        methodInfo.addAttribute((AttributeInfo)DynamicClassGenerator.copyConstructorParametersAnnotations(classPool, constPool, ctor, anchor != null));
        SignatureAttribute info = DynamicClassGenerator.copyConstructorGenericsSignature(constPool, parameters, ctType, anchor);
        if (info != null) {
            methodInfo.addAttribute((AttributeInfo)info);
        }
        impl.addConstructor(ctConstructor);
    }

    private static void createAnchorConstructor(CtClass impl, CtClass anchor) throws Exception {
        ClassPool classPool = impl.getClassPool();
        CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{anchor}, null, (int)0, null, null, (CtClass)impl);
        ConstPool constPool = impl.getClassFile().getConstPool();
        MethodInfo methodInfo = ctConstructor.getMethodInfo();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation(constPool, classPool.get(javax.inject.Inject.class.getName()));
        attr.addAnnotation(annotation);
        methodInfo.addAttribute((AttributeInfo)attr);
        impl.addConstructor(ctConstructor);
    }

    private static Constructor findDIConstructor(Class<?> type) {
        Constructor<?> target = null;
        for (Constructor<?> ctor : type.getConstructors()) {
            if (!ctor.isAnnotationPresent(Inject.class) && !ctor.isAnnotationPresent(javax.inject.Inject.class)) continue;
            target = ctor;
            break;
        }
        return target;
    }

    private static ParameterAnnotationsAttribute copyConstructorParametersAnnotations(ClassPool classPool, ConstPool constPool, Constructor ctor, boolean anchorAdded) throws Exception {
        int count = ctor.getParameterTypes().length;
        javassist.bytecode.annotation.Annotation[][] paramAnnotations = new javassist.bytecode.annotation.Annotation[count + (anchorAdded ? 1 : 0)][];
        for (int i = 0; i < count; ++i) {
            Annotation[] anns = ctor.getParameterAnnotations()[i];
            paramAnnotations[i] = new javassist.bytecode.annotation.Annotation[anns.length];
            for (int j = 0; j < anns.length; ++j) {
                paramAnnotations[i][j] = JavassistUtils.copyAnnotation(classPool, constPool, anns[j]);
            }
        }
        if (anchorAdded) {
            paramAnnotations[count] = new javassist.bytecode.annotation.Annotation[0];
        }
        ParameterAnnotationsAttribute paramAnns = new ParameterAnnotationsAttribute(constPool, "RuntimeVisibleParameterAnnotations");
        paramAnns.setAnnotations((javassist.bytecode.annotation.Annotation[][])paramAnnotations);
        return paramAnns;
    }

    private static void applyScopeAnnotation(ClassPool classPool, AnnotationsAttribute annotations, AnnotatedElement source, Class<? extends Annotation> scope) throws Exception {
        if (scope != null) {
            Preconditions.checkState((boolean)Annotations.isScopeAnnotation(scope), (String)"Provided annotation %s is not scope annotation", (Object[])new Object[]{scope.getSimpleName()});
            for (Annotation ann : source.getAnnotations()) {
                Preconditions.checkArgument((!(ann instanceof ScopeAnnotation) ? 1 : 0) != 0, (String)"Duplicate scope definition: scope is specified as %s and also defined in @ScopeAnnotation.", (Object[])new Object[]{scope.getSimpleName()});
            }
            annotations.addAnnotation(new javassist.bytecode.annotation.Annotation(annotations.getConstPool(), classPool.get(scope.getName())));
        }
    }

    private static AnnotationsAttribute copyAnnotations(ClassPool classPool, ConstPool constPool, AnnotatedElement source) throws Exception {
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        if (source.getAnnotations().length > 0) {
            for (Annotation ann : source.getAnnotations()) {
                javassist.bytecode.annotation.Annotation annotation = DynamicClassGenerator.processAnnotation(classPool, constPool, ann);
                if (annotation == null) continue;
                attr.addAnnotation(annotation);
            }
        }
        return attr;
    }

    private static javassist.bytecode.annotation.Annotation processAnnotation(ClassPool classPool, ConstPool constPool, Annotation ann) throws Exception {
        javassist.bytecode.annotation.Annotation res = null;
        if (!(ann instanceof ProvidedBy) && !(ann instanceof ImplementedBy)) {
            Preconditions.checkState((!Annotations.isScopeAnnotation(ann.annotationType()) ? 1 : 0) != 0, (Object)"Don't use scope annotations directly - use @ScopeAnnotation(TargetScope) wrapper, because guice doesn't allow scope annotations on abstract types");
            res = ann instanceof ScopeAnnotation ? new javassist.bytecode.annotation.Annotation(constPool, classPool.get(((ScopeAnnotation)ann).value().getName())) : JavassistUtils.copyAnnotation(classPool, constPool, ann);
        }
        return res;
    }

    private static SignatureAttribute copyConstructorGenericsSignature(ConstPool constPool, CtClass[] params, CtClass source, CtClass anchor) throws Exception {
        CtConstructor ctConstructor = source.getConstructor(Descriptor.ofConstructor((CtClass[])params));
        String signature = null;
        for (Object attr : ctConstructor.getMethodInfo().getAttributes()) {
            if (!(attr instanceof SignatureAttribute)) continue;
            signature = ((SignatureAttribute)attr).getSignature();
            break;
        }
        if (signature != null && anchor != null) {
            String type = "L" + anchor.getName().replaceAll("\\.", "/") + ";";
            int idx = signature.lastIndexOf(41);
            signature = signature.substring(0, idx) + type + signature.substring(idx);
        }
        return signature == null ? null : new SignatureAttribute(constPool, signature);
    }
}

