/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.base.Objects;
import com.google.inject.grapher.Edge;
import com.google.inject.grapher.NodeId;
import com.google.inject.spi.InjectionPoint;

public class DependencyEdge
extends Edge {
    private final InjectionPoint injectionPoint;

    public DependencyEdge(NodeId fromId, NodeId toId, InjectionPoint injectionPoint) {
        super(fromId, toId);
        this.injectionPoint = injectionPoint;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DependencyEdge)) {
            return false;
        }
        DependencyEdge other = (DependencyEdge)obj;
        return super.equals(other) && Objects.equal((Object)this.injectionPoint, (Object)other.injectionPoint);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.injectionPoint});
    }

    public String toString() {
        return "DependencyEdge{fromId=" + this.getFromId() + " toId=" + this.getToId() + " injectionPoint=" + this.injectionPoint + "}";
    }

    @Override
    public Edge copy(NodeId fromId, NodeId toId) {
        return new DependencyEdge(fromId, toId, this.injectionPoint);
    }
}

