/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.ServletDefinition;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

@Singleton
class ManagedServletPipeline {
    private final ServletDefinition[] servletDefinitions;
    private static final TypeLiteral<ServletDefinition> SERVLET_DEFS = TypeLiteral.get(ServletDefinition.class);
    public static final String REQUEST_DISPATCHER_REQUEST = "jakarta.servlet.forward.servlet_path";

    @Inject
    public ManagedServletPipeline(Injector injector) {
        this.servletDefinitions = this.collectServletDefinitions(injector);
    }

    boolean hasServletsMapped() {
        return this.servletDefinitions.length > 0;
    }

    private ServletDefinition[] collectServletDefinitions(Injector injector) {
        ArrayList servletDefinitions = Lists.newArrayList();
        for (Binding entry : injector.findBindingsByType(SERVLET_DEFS)) {
            servletDefinitions.add((ServletDefinition)entry.getProvider().get());
        }
        return servletDefinitions.toArray(new ServletDefinition[servletDefinitions.size()]);
    }

    public void init(ServletContext servletContext, Injector injector) throws ServletException {
        Set initializedSoFar = Sets.newIdentityHashSet();
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            servletDefinition.init(servletContext, injector, initializedSoFar);
        }
    }

    public boolean service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            if (!servletDefinition.service(request, response)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        Set destroyedSoFar = Sets.newIdentityHashSet();
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            servletDefinition.destroy(destroyedSoFar);
        }
    }

    RequestDispatcher getRequestDispatcher(String path) {
        final String newRequestUri = path;
        for (final ServletDefinition servletDefinition : this.servletDefinitions) {
            if (!servletDefinition.shouldServe(path)) continue;
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    Preconditions.checkState((!servletResponse.isCommitted() ? 1 : 0) != 0, (Object)"Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                    servletResponse.resetBuffer();
                    Object requestToProcess = servletRequest instanceof HttpServletRequest ? ManagedServletPipeline.wrapRequest((HttpServletRequest)servletRequest, newRequestUri) : servletRequest;
                    this.doServiceImpl(servletDefinition, (ServletRequest)requestToProcess, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    this.doServiceImpl(servletDefinition, servletRequest, servletResponse);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void doServiceImpl(ServletDefinition servletDefinition2, ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    servletRequest.setAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                    try {
                        servletDefinition2.doService(servletRequest, servletResponse);
                    }
                    finally {
                        servletRequest.removeAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST);
                    }
                }
            };
        }
        return null;
    }

    static HttpServletRequest wrapRequest(HttpServletRequest request, String newUri) {
        return new RequestDispatcherRequestWrapper(request, newUri);
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(HttpServletRequest servletRequest, String newRequestUri) {
            super(servletRequest);
            this.newRequestUri = newRequestUri;
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }

        public StringBuffer getRequestURL() {
            StringBuffer url = new StringBuffer();
            String scheme = this.getScheme();
            int port = this.getServerPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (port > 0 && ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443)) {
                url.append(':');
                url.append(port);
            }
            url.append(this.getRequestURI());
            return url;
        }
    }
}

