/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.internal.Errors;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.ThrowingProvider;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

final class ProviderChecker {
    private ProviderChecker() {
    }

    static <P extends CheckedProvider<?>> void checkInterface(Class<P> interfaceType, Optional<? extends Type> valueType) {
        List declaredMethods;
        boolean tpMode;
        ProviderChecker.checkArgument(interfaceType.isInterface(), "%s must be an interface", interfaceType.getName());
        ProviderChecker.checkArgument(interfaceType.getGenericInterfaces().length == 1, "%s must extend CheckedProvider (and only CheckedProvider)", interfaceType);
        boolean bl = tpMode = interfaceType.getInterfaces()[0] == ThrowingProvider.class;
        if (!tpMode) {
            ProviderChecker.checkArgument(interfaceType.getInterfaces()[0] == CheckedProvider.class, "%s must extend CheckedProvider (and only CheckedProvider)", interfaceType);
        }
        ParameterizedType genericThrowingProvider = (ParameterizedType)interfaceType.getGenericInterfaces()[0];
        if (interfaceType.getTypeParameters().length == 1) {
            String returnTypeName = interfaceType.getTypeParameters()[0].getName();
            Type returnType = genericThrowingProvider.getActualTypeArguments()[0];
            ProviderChecker.checkArgument(returnType instanceof TypeVariable, "%s does not properly extend CheckedProvider, the first type parameter of CheckedProvider (%s) is not a generic type", interfaceType, returnType);
            ProviderChecker.checkArgument(returnTypeName.equals(((TypeVariable)returnType).getName()), "The generic type (%s) of %s does not match the generic type of CheckedProvider (%s)", returnTypeName, interfaceType, ((TypeVariable)returnType).getName());
        } else {
            ProviderChecker.checkArgument(interfaceType.getTypeParameters().length == 0, "%s has more than one generic type parameter: %s", interfaceType, Arrays.asList(interfaceType.getTypeParameters()));
            if (valueType.isPresent()) {
                ProviderChecker.checkArgument(genericThrowingProvider.getActualTypeArguments()[0].equals(valueType.get()), "%s expects the value type to be %s, but it was %s", interfaceType, genericThrowingProvider.getActualTypeArguments()[0], valueType.get());
            }
        }
        if (tpMode) {
            Type exceptionType = genericThrowingProvider.getActualTypeArguments()[1];
            ProviderChecker.checkArgument(exceptionType instanceof Class, "%s has the wrong Exception generic type (%s) when extending CheckedProvider", interfaceType, exceptionType);
        }
        if ((declaredMethods = (List)Arrays.stream(interfaceType.getDeclaredMethods()).filter((Predicate<Method>)((Object)NotSyntheticOrBridgePredicate.INSTANCE)).collect(ImmutableList.toImmutableList())).size() == 1) {
            Method method = (Method)declaredMethods.get(0);
            ProviderChecker.checkArgument(method.getName().equals("get"), "%s may not declare any new methods, but declared %s", interfaceType, method);
            ProviderChecker.checkArgument(method.getParameterTypes().length == 0, "%s may not declare any new methods, but declared %s", interfaceType, method.toGenericString());
        } else {
            ProviderChecker.checkArgument(declaredMethods.isEmpty(), "%s may not declare any new methods, but declared %s", interfaceType, Arrays.asList(interfaceType.getDeclaredMethods()));
        }
    }

    private static void checkArgument(boolean condition, String messageFormat, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(Errors.format((String)messageFormat, (Object[])args));
        }
    }

    private static class NotSyntheticOrBridgePredicate
    implements com.google.common.base.Predicate<Method> {
        static final NotSyntheticOrBridgePredicate INSTANCE = new NotSyntheticOrBridgePredicate();

        private NotSyntheticOrBridgePredicate() {
        }

        public boolean apply(Method input) {
            return !input.isBridge() && !input.isSynthetic();
        }
    }
}

