/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.admin.log;

import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Callback;
import ru.vyarus.guicey.admin.rest.AdminRestServlet;

public class LogbackAccessRequestLogAwareCustomHandler
extends Handler.Wrapper {
    private final boolean identifyAdminContext;

    public LogbackAccessRequestLogAwareCustomHandler(boolean identifyAdminContext) {
        this.identifyAdminContext = identifyAdminContext;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        boolean handled = super.handle(request, response, callback);
        if (handled && request.getAttribute(AdminRestServlet.ADMIN_PROPERTY) != null) {
            ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
            if (this.identifyAdminContext) {
                servletContextRequest = (ServletContextRequest)servletContextRequest.wrap(request, (HttpURI)HttpURI.build((HttpURI)request.getHttpURI()).uri(request.getHttpURI() + " (ADMIN REST)"));
            }
            if (servletContextRequest != null) {
                Request unwrapped = Request.unWrap((Request)request);
                if (!(unwrapped instanceof HttpChannelState.ChannelRequest)) {
                    throw new IllegalStateException("Expecting unwrapped request to be an instance of HttpChannelState.ChannelRequest");
                }
                HttpChannelState.ChannelRequest channelRequest = (HttpChannelState.ChannelRequest)unwrapped;
                channelRequest.setLoggedRequest((Request)servletContextRequest);
            }
        }
        return handled;
    }
}

