/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.eventbus;

import com.google.common.eventbus.EventBus;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import io.dropwizard.Application;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.guicey.eventbus.module.EventBusModule;
import ru.vyarus.guicey.eventbus.module.TypeLiteralAdapterMatcher;
import ru.vyarus.guicey.eventbus.report.EventSubscribersReporter;

public class EventBusBundle
implements GuiceyBundle {
    private final EventBus eventbus;
    private Matcher<? super TypeLiteral<?>> typeMatcher = Matchers.any();
    private boolean report = true;

    public EventBusBundle() {
        this(new EventBus("bus"));
    }

    public EventBusBundle(EventBus eventbus) {
        this.eventbus = eventbus;
    }

    public EventBusBundle withMatcher(Matcher<? super Class<?>> classMatcher) {
        this.typeMatcher = new TypeLiteralAdapterMatcher(classMatcher);
        return this;
    }

    public EventBusBundle noReport() {
        this.report = false;
        return this;
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        bootstrap.modules(new Module[]{new EventBusModule(this.eventbus, this.typeMatcher)});
        if (this.report) {
            this.registerReport(bootstrap);
        }
    }

    private void registerReport(final GuiceyBootstrap bootstrap) {
        bootstrap.environment().lifecycle().addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarted(LifeCycle event) {
                EventSubscribersReporter reporter = new EventSubscribersReporter();
                ((Injector)InjectorLookup.getInjector((Application)bootstrap.application()).get()).injectMembers((Object)reporter);
                reporter.report();
            }
        });
    }
}

