/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscriber;
import com.google.common.eventbus.SubscriberRegistry;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubscriptionIntrospector {
    private static final String SUBSCRIBERS_FIELD = "subscribers";
    private final EventBus eventbus;
    private Map<Class, Set<Subscriber>> subscribers;

    public SubscriptionIntrospector(EventBus eventbus) {
        this.eventbus = eventbus;
    }

    public Set<Class> getListenedEvents() {
        return this.extractSubscribers().keySet();
    }

    public Set<Object> getSubscribers(Class event) {
        HashSet<Object> res = new HashSet<Object>();
        Set<Subscriber> subscribers = this.extractSubscribers().get(event);
        if (subscribers != null) {
            for (Subscriber subs : subscribers) {
                res.add(subs.target);
            }
        }
        return res;
    }

    public Set<Class> getSubscriberTypes(Class event) {
        HashSet<Class> res = new HashSet<Class>();
        for (Object obj : this.getSubscribers(event)) {
            res.add(this.extractType(obj));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class, Set<Subscriber>> extractSubscribers() {
        SubscriptionIntrospector subscriptionIntrospector = this;
        synchronized (subscriptionIntrospector) {
            if (this.subscribers == null) {
                try {
                    Field registryField = EventBus.class.getDeclaredField(SUBSCRIBERS_FIELD);
                    registryField.setAccessible(true);
                    SubscriberRegistry registry = (SubscriberRegistry)registryField.get(this.eventbus);
                    Field subscribersField = SubscriberRegistry.class.getDeclaredField(SUBSCRIBERS_FIELD);
                    subscribersField.setAccessible(true);
                    this.subscribers = (Map)Preconditions.checkNotNull((Object)subscribersField.get(registry));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to access subscribers collection", e);
                }
            }
            return this.subscribers;
        }
    }

    private Class extractType(Object instance) {
        Class<?> cls = instance.getClass();
        while (cls.getSuperclass() != Object.class && cls.getSimpleName().contains("$")) {
            cls = cls.getSuperclass();
        }
        return cls;
    }
}

