/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.eventbus;

import com.google.common.eventbus.EventBus;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import ru.vyarus.dropwizard.guice.module.context.unique.item.UniqueGuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.guicey.eventbus.module.EventBusModule;
import ru.vyarus.guicey.eventbus.module.TypeLiteralAdapterMatcher;
import ru.vyarus.guicey.eventbus.report.EventSubscribersReporter;
import ru.vyarus.guicey.eventbus.service.EventSubscribersInfo;

public class EventBusBundle
extends UniqueGuiceyBundle {
    private final EventBus eventbus;
    private Matcher<? super TypeLiteral<?>> typeMatcher = Matchers.any();
    private boolean report = true;

    public EventBusBundle() {
        this(new EventBus("bus"));
    }

    public EventBusBundle(EventBus eventbus) {
        this.eventbus = eventbus;
    }

    public EventBusBundle withMatcher(Matcher<? super Class<?>> classMatcher) {
        this.typeMatcher = new TypeLiteralAdapterMatcher(classMatcher);
        return this;
    }

    public EventBusBundle noReport() {
        this.report = false;
        return this;
    }

    public void run(GuiceyEnvironment environment) {
        environment.modules(new Module[]{new EventBusModule(this.eventbus, this.typeMatcher)});
        if (this.report) {
            environment.onApplicationStartup(injector -> new EventSubscribersReporter((EventSubscribersInfo)injector.getInstance(EventSubscribersInfo.class)).report());
        }
    }
}

