/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.eventbus.report;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guicey.eventbus.service.EventSubscribersInfo;

public class EventSubscribersReporter {
    private final Logger logger = LoggerFactory.getLogger(EventSubscribersReporter.class);
    private final EventSubscribersInfo info;

    public EventSubscribersReporter(EventSubscribersInfo info) {
        this.info = info;
    }

    public String renderReport() {
        Set<Class> events = this.info.getListenedEvents();
        if (events.isEmpty()) {
            return null;
        }
        ArrayList<Class> sortedEvents = new ArrayList<Class>(events);
        sortedEvents.sort(Comparator.comparing(Class::getSimpleName));
        StringBuilder res = new StringBuilder("EventBus subscribers = ").append(Reporter.NEWLINE);
        for (Class event : sortedEvents) {
            res.append(Reporter.NEWLINE).append("    ").append(event.getSimpleName()).append(Reporter.NEWLINE);
            for (Class subs : this.info.getListenerTypes(event)) {
                res.append("    ").append("    ").append(subs.getName()).append(Reporter.NEWLINE);
            }
        }
        return res.toString();
    }

    public void report() {
        String report = this.renderReport();
        if (report != null) {
            this.logger.info(report);
        }
    }
}

