/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.db.PooledDataSourceFactory;
import java.lang.annotation.Annotation;
import java.util.List;
import org.skife.jdbi.v2.DBI;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.guicey.jdbi.dbi.ConfigAwareProvider;
import ru.vyarus.guicey.jdbi.dbi.SimpleDbiProvider;
import ru.vyarus.guicey.jdbi.installer.MapperInstaller;
import ru.vyarus.guicey.jdbi.installer.repository.RepositoryInstaller;
import ru.vyarus.guicey.jdbi.module.JdbiModule;
import ru.vyarus.guicey.jdbi.tx.InTransaction;

public final class JdbiBundle
implements GuiceyBundle {
    private final ConfigAwareProvider<DBI, ?> dbi;
    private List<Class<? extends Annotation>> txAnnotations = ImmutableList.builder().add(InTransaction.class).build();

    private JdbiBundle(ConfigAwareProvider<DBI, ?> dbi) {
        this.dbi = dbi;
    }

    @SafeVarargs
    public final JdbiBundle withTxAnnotations(Class<? extends Annotation> ... txAnnotations) {
        this.txAnnotations = Lists.newArrayList((Object[])txAnnotations);
        return this;
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        DBI jdbi = this.dbi.get(bootstrap.configuration(), bootstrap.environment());
        bootstrap.installers(new Class[]{RepositoryInstaller.class, MapperInstaller.class}).modules(new Module[]{new JdbiModule(jdbi, this.txAnnotations)});
    }

    public static <C extends Configuration> JdbiBundle forDbi(ConfigAwareProvider<DBI, C> dbi) {
        return new JdbiBundle(dbi);
    }

    public static <C extends Configuration> JdbiBundle forDatabase(ConfigAwareProvider<PooledDataSourceFactory, C> db) {
        return JdbiBundle.forDbi(new SimpleDbiProvider<C>(db));
    }
}

