/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi.installer.repository;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Stage;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import org.skife.jdbi.v2.sqlobject.SqlObjectFactory;
import org.skife.jdbi.v2.sqlobject.UnitHandleDing;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guice.ext.core.generator.DynamicClassGenerator;
import ru.vyarus.guicey.jdbi.installer.repository.JdbiRepository;
import ru.vyarus.guicey.jdbi.module.NoSyntheticMatcher;

public class RepositoryInstaller
implements FeatureInstaller<Object>,
BindingInstaller {
    private final Reporter reporter = new Reporter(RepositoryInstaller.class, "repositories = ");
    private UnitHandleDing ding;

    public boolean matches(Class<?> type) {
        return type.getAnnotation(JdbiRepository.class) != null;
    }

    public void bindExtension(Binder binder, Class<?> type, boolean lazy) {
        Preconditions.checkState((!lazy ? 1 : 0) != 0, (Object)"@LazyBinding not supported");
        Object jdbiProxy = SqlObjectFactory.instance(type, this.getDing(binder));
        binder.requestInjection(jdbiProxy);
        Class guiceType = DynamicClassGenerator.generate(type);
        binder.bind(type).to(guiceType).in(Singleton.class);
        binder.bindInterceptor(Matchers.subclassesOf(type), (Matcher)NoSyntheticMatcher.instance(), new MethodInterceptor[]{invocation -> {
            try {
                return invocation.getMethod().invoke(jdbiProxy, invocation.getArguments());
            }
            catch (InvocationTargetException th) {
                throw th.getCause();
            }
        }});
    }

    public <T> void checkBinding(Binder binder, Class<T> type, Binding<T> manualBinding) {
    }

    public void installBinding(Binder binder, Class<?> type) {
        if (binder.currentStage() != Stage.TOOL) {
            this.reporter.line(String.format("(%s)", type.getName()), new Object[0]);
        }
    }

    public void report() {
        this.reporter.report();
    }

    private UnitHandleDing getDing(Binder binder) {
        if (this.ding == null) {
            this.ding = new UnitHandleDing();
            binder.requestInjection((Object)this.ding);
        }
        return this.ding;
    }
}

