/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi.tx;

import com.google.common.base.Throwables;
import javax.inject.Inject;
import javax.inject.Singleton;
import ru.vyarus.guicey.jdbi.tx.TxAction;
import ru.vyarus.guicey.jdbi.unit.UnitManager;

@Singleton
public class TransactionTemplate {
    private final UnitManager manager;

    @Inject
    public TransactionTemplate(UnitManager manager) {
        this.manager = manager;
    }

    public <T> T inTransaction(TxAction<T> action) {
        if (this.manager.isUnitStarted()) {
            try {
                return action.execute(this.manager.get());
            }
            catch (Throwable th) {
                Throwables.throwIfUnchecked((Throwable)th);
                throw new RuntimeException(th);
            }
        }
        this.manager.beginUnit();
        try {
            Object object = this.manager.get().inTransaction((conn, status) -> action.execute(this.manager.get()));
            return (T)object;
        }
        finally {
            this.manager.endUnit();
        }
    }
}

