/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi.unit;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UnitManager
implements Provider<Handle> {
    private final Logger logger = LoggerFactory.getLogger(UnitManager.class);
    private final DBI dbi;
    private final ThreadLocal<Handle> unit = new ThreadLocal();

    @Inject
    public UnitManager(DBI dbi) {
        this.dbi = dbi;
    }

    public Handle get() {
        Preconditions.checkState((boolean)this.isUnitStarted(), (Object)"Unit of work not started yet");
        return this.unit.get();
    }

    public boolean isUnitStarted() {
        return this.unit.get() != null;
    }

    public void beginUnit() {
        Preconditions.checkState((!this.isUnitStarted() ? 1 : 0) != 0, (Object)"Unit of work already started");
        Handle handle = this.dbi.open();
        this.unit.set(handle);
        this.logger.trace("Transaction start");
    }

    public void endUnit() {
        Preconditions.checkState((boolean)this.isUnitStarted(), (Object)"Stop called outside of unit of work");
        Handle handle = this.unit.get();
        this.unit.remove();
        try {
            handle.close();
        }
        catch (Exception ex) {
            this.logger.warn("JDBI handle close error ({})", (Object)ex.getMessage());
        }
        this.logger.trace("Transaction end");
    }
}

