/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;

@Singleton
public class TransactionalHandleSupplier
implements HandleSupplier {
    private final Jdbi jdbi;
    private final Provider<Handle> handleProvider;

    @Inject
    public TransactionalHandleSupplier(Jdbi jdbi, Provider<Handle> handleProvider) {
        this.jdbi = jdbi;
        this.handleProvider = handleProvider;
    }

    public Handle getHandle() {
        return (Handle)this.handleProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
        Handle handle = this.getHandle();
        ExtensionMethod oldExtensionMethod = handle.getExtensionMethod();
        try {
            V v;
            handle.setExtensionMethod(extensionMethod);
            ConfigRegistry oldConfig = handle.getConfig();
            try {
                handle.setConfig(config);
                v = task.call();
            }
            catch (Throwable throwable) {
                handle.setConfig(oldConfig);
                throw throwable;
            }
            handle.setConfig(oldConfig);
            return v;
        }
        finally {
            handle.setExtensionMethod(oldExtensionMethod);
        }
    }

    public ConfigRegistry getConfig() {
        return this.jdbi.getConfig();
    }
}

