/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.installer;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Stage;
import com.google.inject.multibindings.Multibinder;
import javax.inject.Singleton;
import org.jdbi.v3.core.mapper.RowMapper;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.java.generics.resolver.GenericsResolver;

public class MapperInstaller
implements FeatureInstaller,
BindingInstaller {
    private final Reporter reporter = new Reporter(MapperInstaller.class, "jdbi row mappers = ");

    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, RowMapper.class);
    }

    public void bind(Binder binder, Class<?> type, boolean lazy) {
        binder.bind(type).in(Singleton.class);
        this.register(binder, type);
    }

    public <T> void manualBinding(Binder binder, Class<T> type, Binding<T> binding) {
        this.register(binder, type);
    }

    private void register(Binder binder, Class<?> type) {
        Multibinder.newSetBinder((Binder)binder, RowMapper.class).addBinding().to(type);
    }

    public void extensionBound(Stage stage, Class<?> type) {
        if (stage != Stage.TOOL) {
            String target = GenericsResolver.resolve(type, (Class[])new Class[0]).type(RowMapper.class).genericAsString(0);
            this.reporter.line("%-20s (%s)", new Object[]{target, type.getName()});
        }
    }

    public void report() {
        this.reporter.report();
    }
}

