/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.installer.repository.sql;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.TransactionalHandleSupplier;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.extension.NoSuchExtensionException;

public class SqlObjectProvider<T>
implements Provider<T> {
    @Inject
    private Jdbi jdbi;
    @Inject
    private TransactionalHandleSupplier handleProvider;
    private final Class<T> extensionType;
    private volatile T res;

    public SqlObjectProvider(Class<T> extensionType) {
        this.extensionType = extensionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.res == null) {
            SqlObjectProvider sqlObjectProvider = this;
            synchronized (sqlObjectProvider) {
                if (this.res == null) {
                    this.res = this.create();
                }
            }
        }
        return this.res;
    }

    public boolean isInitialized() {
        return this.res != null;
    }

    private T create() {
        if (!this.extensionType.isInterface()) {
            throw new IllegalArgumentException("On-demand extensions are only supported for interfaces.");
        }
        return ((Extensions)this.jdbi.getConfig(Extensions.class)).findFor(this.extensionType, (HandleSupplier)this.handleProvider).orElseThrow(() -> new NoSuchExtensionException("Extension not found: " + this.extensionType));
    }
}

