/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.tx;

import com.google.common.base.Throwables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import ru.vyarus.guicey.jdbi3.tx.TxAction;
import ru.vyarus.guicey.jdbi3.tx.TxConfig;
import ru.vyarus.guicey.jdbi3.unit.UnitManager;

@Singleton
public class TransactionTemplate {
    private final UnitManager manager;

    @Inject
    public TransactionTemplate(UnitManager manager) {
        this.manager = manager;
    }

    public <T> T inTransaction(TxAction<T> action) {
        return this.inTransaction(new TxConfig(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T inTransaction(TxConfig config, TxAction<T> action) {
        if (this.manager.isUnitStarted()) {
            try {
                return this.inCurrentTransaction(config, action);
            }
            catch (Throwable th) {
                Throwables.throwIfUnchecked((Throwable)th);
                throw new RuntimeException(th);
            }
        }
        this.manager.beginUnit();
        try {
            T t = this.inNewTransaction(config, action);
            return t;
        }
        finally {
            this.manager.endUnit();
        }
    }

    private <T> T inCurrentTransaction(TxConfig config, TxAction<T> action) throws Exception {
        Handle h = this.manager.get();
        TransactionIsolationLevel currentLevel = h.getTransactionIsolationLevel();
        if (config.isLevelSet() && currentLevel != config.getLevel()) {
            throw new TransactionException("Tried to execute nested @Transaction(" + config.getLevel() + "), but already running in a transaction with isolation level " + currentLevel + ".");
        }
        if (h.isReadOnly() && !config.isReadOnly()) {
            throw new TransactionException("Tried to execute a nested @Transaction(readOnly=false) inside a readOnly transaction");
        }
        return action.execute(h);
    }

    private <T> T inNewTransaction(TxConfig config, TxAction<T> action) {
        Handle h = this.manager.get();
        h.setReadOnly(config.isReadOnly());
        HandleCallback callback = handle -> {
            try {
                return action.execute(handle);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
        return (T)(config.isLevelSet() ? h.inTransaction(config.getLevel(), callback) : h.inTransaction(callback));
    }
}

