/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.inject;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerFactory;
import org.jdbi.v3.core.extension.HandleSupplier;

public class InjectionHandlerFactory
implements ExtensionHandlerFactory {
    @jakarta.inject.Inject
    private Injector injector;

    public boolean accepts(Class<?> extensionType, Method method) {
        return method.getAnnotation(jakarta.inject.Inject.class) != null || method.getAnnotation(Inject.class) != null;
    }

    public Optional<ExtensionHandler> createExtensionHandler(Class<?> extensionType, Method method) {
        return Optional.of(new InjectionHandler(this.injector, method.getReturnType()));
    }

    private static class InjectionHandler
    implements ExtensionHandler {
        private final Injector injector;
        private final Class<?> type;

        InjectionHandler(Injector injector, Class<?> type) {
            this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"No injector");
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"No type");
            Preconditions.checkState((type != Void.class && type != Void.TYPE ? 1 : 0) != 0, (Object)"Only non void (getter) method could be anotated with @Inject in orderto provide guice bean.");
        }

        public Object invoke(HandleSupplier handleSupplier, Object target, Object ... args) throws Exception {
            return this.injector.getInstance(this.type);
        }
    }
}

