/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.installer.repository;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Stage;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guice.ext.core.generator.DynamicClassGenerator;
import ru.vyarus.guicey.jdbi3.installer.repository.JdbiRepository;
import ru.vyarus.guicey.jdbi3.installer.repository.sql.SqlObjectProvider;
import ru.vyarus.guicey.jdbi3.module.NoSyntheticMatcher;
import ru.vyarus.java.generics.resolver.GenericsResolver;

public class RepositoryInstaller
implements FeatureInstaller,
BindingInstaller {
    private final Reporter reporter = new Reporter(RepositoryInstaller.class, "repositories = ");
    private final Set<Class> bound = new HashSet<Class>();

    public boolean matches(Class<?> type) {
        boolean res;
        boolean bl = res = type.getAnnotation(JdbiRepository.class) != null;
        if (res) {
            this.validateCorrectness(type);
        }
        return res;
    }

    public void bind(Binder binder, Class<?> type, boolean lazy) {
        Preconditions.checkState((!lazy ? 1 : 0) != 0, (Object)"@LazyBinding not supported");
        this.generateRepository(binder, type);
    }

    public <T> void manualBinding(Binder binder, Class<T> type, Binding<T> binding) {
        if (binding.getKey().getTypeLiteral().getRawType() == type) {
            throw new UnsupportedOperationException(String.format("JDBI repository %s can't be installed from binding: %s", type.getSimpleName(), GuiceModelUtils.getDeclarationSource(binding).toString()));
        }
        this.generateRepository(binder, type);
    }

    public void extensionBound(Stage stage, Class<?> type) {
        if (stage != Stage.TOOL) {
            this.reporter.line(String.format("(%s)", type.getName()), new Object[0]);
        }
    }

    public void report() {
        this.reporter.report();
    }

    public List<String> getRecognizableSigns() {
        return Collections.singletonList("@" + JdbiRepository.class + " on class");
    }

    private void generateRepository(Binder binder, Class<?> type) {
        if (this.bound.contains(type)) {
            return;
        }
        SqlObjectProvider<Object> jdbiProxy = new SqlObjectProvider<Object>(type);
        binder.requestInjection(jdbiProxy);
        Multibinder.newSetBinder((Binder)binder, SqlObjectProvider.class, (Annotation)Names.named((String)"jdbi3.proxies")).addBinding().toInstance(jdbiProxy);
        Class guiceType = DynamicClassGenerator.generate(type);
        binder.bind(type).to(guiceType).in(Singleton.class);
        binder.bindInterceptor(Matchers.subclassesOf(type), (Matcher)NoSyntheticMatcher.instance(), new MethodInterceptor[]{new JdbiProxyRedirect(jdbiProxy)});
        if (binder.currentStage() != Stage.TOOL) {
            this.bound.add(type);
        }
    }

    private void validateCorrectness(Class<?> type) {
        for (Class check : GenericsResolver.resolve(type, (Class[])new Class[0]).getGenericsInfo().getComposingTypes()) {
            if (check.equals(type) || !check.isAnnotationPresent(JdbiRepository.class)) continue;
            throw new IllegalStateException(String.format("Incorrect repository %s declaration: base interface %s is also annotated with @%s which may break AOP mappings. Only root repository class must be annotated.", type.getSimpleName(), check.getSimpleName(), JdbiRepository.class.getSimpleName()));
        }
    }

    public static class JdbiProxyRedirect
    implements MethodInterceptor {
        private final Provider<Object> jdbiProxy;

        public JdbiProxyRedirect(Provider<Object> jdbiProxy) {
            this.jdbiProxy = jdbiProxy;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            try {
                return invocation.getMethod().invoke(this.jdbiProxy.get(), invocation.getArguments());
            }
            catch (InvocationTargetException th) {
                throw th.getCause();
            }
        }
    }
}

