/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.unit;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UnitManager
implements Provider<Handle> {
    private final Logger logger = LoggerFactory.getLogger(UnitManager.class);
    private final Jdbi jdbi;
    private final ThreadLocal<Handle> unit = new ThreadLocal();

    @Inject
    public UnitManager(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public Handle get() {
        Preconditions.checkState((boolean)this.isUnitStarted(), (Object)"Unit of work not started yet");
        return this.unit.get();
    }

    public boolean isUnitStarted() {
        return this.unit.get() != null;
    }

    public void beginUnit() {
        Preconditions.checkState((!this.isUnitStarted() ? 1 : 0) != 0, (Object)"Unit of work already started");
        Handle handle = this.jdbi.open();
        this.unit.set(handle);
        this.logger.trace("Transaction start");
    }

    public void endUnit() {
        Preconditions.checkState((boolean)this.isUnitStarted(), (Object)"Stop called outside of unit of work");
        Handle handle = this.unit.get();
        this.unit.remove();
        try {
            handle.close();
        }
        catch (Exception ex) {
            this.logger.warn("JDBI handle close error ({})", (Object)ex.getMessage());
        }
        this.logger.trace("Transaction end");
    }
}

