/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.annotations.lifecycle.module.collector;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.guicey.annotations.lifecycle.module.collector.MethodInstance;

public class MethodsCollector {
    private final Logger logger = LoggerFactory.getLogger(MethodsCollector.class);
    private final Multimap<Class<? extends Annotation>, MethodInstance> listeners = LinkedListMultimap.create();
    private final List<Class<? extends Annotation>> processed = new ArrayList<Class<? extends Annotation>>();

    public void register(Class<? extends Annotation> annotation, Object instance, Method method) {
        MethodInstance methodInstance = new MethodInstance(instance, method);
        this.listeners.put(annotation, (Object)methodInstance);
        if (this.processed.contains(annotation)) {
            this.logger.warn("@{} listener registered after event processing: {}. This could happen when bean is not registered and instantiated on demand (by guice JIT). To avoid this warning register bean directly in guice module. Immediate initialization will be performed.", (Object)annotation.getSimpleName(), (Object)methodInstance);
            this.callInstance(annotation, methodInstance, true);
        }
    }

    public void call(Class<? extends Annotation> annotation) {
        this.doCall(annotation, false);
    }

    public void safeCall(Class<? extends Annotation> annotation) {
        this.doCall(annotation, true);
    }

    private void doCall(Class<? extends Annotation> annotation, boolean safe) {
        Preconditions.checkState((!this.processed.contains(annotation) ? 1 : 0) != 0, (String)"Lifecycle @%s methods were already processed", (Object)annotation.getSimpleName());
        this.processed.add(annotation);
        Collection methods = this.listeners.get(annotation);
        if (!methods.isEmpty()) {
            this.logger.debug("Executing @{} lifecycle methods", (Object)annotation.getSimpleName());
            for (MethodInstance method : methods) {
                this.callInstance(annotation, method, safe);
            }
        }
    }

    private void callInstance(Class<? extends Annotation> annotation, MethodInstance method, boolean safe) {
        try {
            method.call();
        }
        catch (Exception ex) {
            if (safe) {
                this.logger.error("Failed to process @" + annotation.getSimpleName() + " annotated method", (Throwable)ex);
            }
            throw ex;
        }
    }
}

