/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.annotations.lifecycle.module;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import ru.vyarus.guice.ext.core.method.AnnotatedMethodTypeListener;
import ru.vyarus.guicey.annotations.lifecycle.PostStartup;
import ru.vyarus.guicey.annotations.lifecycle.module.collector.MethodsCollector;
import ru.vyarus.guicey.annotations.lifecycle.module.collector.SimpleAnnotationProcessor;

public class LifecycleAnnotationsModule
extends AbstractModule {
    private final Matcher<? super TypeLiteral<?>> typeMatcher;
    private final MethodsCollector collector = new MethodsCollector();

    public LifecycleAnnotationsModule(Matcher<? super TypeLiteral<?>> typeMatcher) {
        this.typeMatcher = typeMatcher;
    }

    public MethodsCollector getCollector() {
        return this.collector;
    }

    protected void configure() {
        this.register(this.collector, PostConstruct.class, PostStartup.class, PreDestroy.class);
    }

    @SafeVarargs
    private final void register(MethodsCollector collector, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> ann : annotations) {
            this.bindListener(this.typeMatcher, (TypeListener)new AnnotatedMethodTypeListener(ann, new SimpleAnnotationProcessor(collector)));
        }
    }
}

