/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import io.dropwizard.setup.Environment;
import java.util.Set;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import ru.vyarus.guicey.gsp.app.GlobalConfig;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.app.rest.log.ResourcePath;
import ru.vyarus.guicey.gsp.app.rest.log.RestPathsAnalyzer;
import ru.vyarus.guicey.gsp.app.util.PathUtils;

public class DelayedInitializer
implements ApplicationEventListener {
    private final GlobalConfig config;
    private final Environment environment;

    public DelayedInitializer(GlobalConfig config, Environment environment) {
        this.config = config;
        this.environment = environment;
        environment.jersey().register((Object)this);
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return null;
    }

    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            this.init();
        } else if (event.getType() == ApplicationEvent.Type.DESTROY_FINISHED) {
            this.config.shutdown();
        }
    }

    private void init() {
        String contextPath = this.environment.getJerseyServletContainer().getServletConfig().getServletContext().getContextPath();
        String restMapping = PathUtils.endSlash(PathUtils.trimStars(this.environment.jersey().getUrlPattern()));
        RestPathsAnalyzer analyzer = RestPathsAnalyzer.build(this.environment.jersey().getResourceConfig());
        for (ServerPagesApp app : this.config.getApps()) {
            Set<ResourcePath> paths = analyzer.select(app.name);
            app.initialize(contextPath, restMapping, paths);
        }
    }
}

