/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.gsp.app;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.dropwizard.Configuration;
import io.dropwizard.views.ViewConfigurable;
import io.dropwizard.views.ViewRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ru.vyarus.guicey.gsp.ServerPagesBundle;
import ru.vyarus.guicey.gsp.app.ServerPagesApp;
import ru.vyarus.guicey.gsp.views.ViewRendererConfigurationModifier;

public class GlobalConfig {
    private final List<String> names = new ArrayList<String>();
    private final List<ServerPagesApp> apps = new ArrayList<ServerPagesApp>();
    private final List<ViewRenderer> renderers = new ArrayList<ViewRenderer>();
    private final Multimap<String, ViewRendererConfigurationModifier> configModifiers = LinkedHashMultimap.create();
    private final Multimap<String, String> extensions = LinkedHashMultimap.create();
    private ViewConfigurable<Configuration> configurable;
    private boolean viewsSupportRegistered;
    private boolean printConfig;
    private Map<String, Map<String, String>> viewsConfig;
    private boolean initialized;
    private boolean shutdown;

    public void globalBundleCreated() {
        Preconditions.checkState((!this.viewsSupportRegistered ? 1 : 0) != 0, (String)"Duplicate server pages support initialization (%s.builder())", (Object)ServerPagesBundle.class.getSimpleName());
        this.viewsSupportRegistered = true;
    }

    public boolean isViewsSupportRegistered() {
        return this.viewsSupportRegistered;
    }

    public ServerPagesApp createApp(String name) {
        Preconditions.checkArgument((!this.names.contains(name) ? 1 : 0) != 0, (String)"Server pages application with name '%s' is already registered", (Object)name);
        this.names.add(name);
        ServerPagesApp app = new ServerPagesApp(this);
        this.apps.add(app);
        return app;
    }

    public List<ServerPagesApp> getApps() {
        return this.apps;
    }

    public List<ViewRenderer> getRenderers() {
        return this.renderers;
    }

    public Map<String, Map<String, String>> getViewsConfig() {
        return this.viewsConfig;
    }

    public Map<String, Map<String, String>> viewsConfig(Map<String, Map<String, String>> viewsConfig) {
        this.viewsConfig = viewsConfig;
        return viewsConfig;
    }

    public void addRenderers(ViewRenderer ... renderers) {
        this.checkAlreadyInitialized();
        for (ViewRenderer renderer : renderers) {
            String key = renderer.getConfigurationKey();
            boolean add = true;
            for (ViewRenderer ren : this.renderers) {
                if (!ren.getConfigurationKey().equals(key)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.renderers.add(renderer);
        }
    }

    public ViewConfigurable<Configuration> getConfigurable() {
        return this.configurable;
    }

    public <T extends Configuration> void setConfigurable(ViewConfigurable<T> configurable) {
        this.configurable = configurable;
    }

    public void addConfigModifier(String name, ViewRendererConfigurationModifier modifier) {
        this.checkAlreadyInitialized();
        this.configModifiers.put((Object)name, (Object)modifier);
    }

    public Multimap<String, ViewRendererConfigurationModifier> getConfigModifiers() {
        return this.configModifiers;
    }

    public boolean isPrintConfiguration() {
        return this.printConfig;
    }

    public void printConfiguration() {
        this.printConfig = true;
    }

    public void initialized() {
        this.initialized = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void extendLocation(String app, String location) {
        for (ServerPagesApp spa : this.apps) {
            if (!spa.name.equals(app)) continue;
            Preconditions.checkState((!spa.isStarted() ? 1 : 0) != 0, (String)"Can't extend already initialized server pages application %s", (Object)app);
            break;
        }
        this.extensions.put((Object)app, (Object)location);
    }

    public Collection<String> getExtensions(String app) {
        return this.extensions.get((Object)app);
    }

    private void checkAlreadyInitialized() {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Global initialization already performed");
    }
}

